<?php

/*

If you'd like to translate your AppGini app, this is
the right file to change! However, please check this page
first as you might found an already existing translation
that you can update instead of starting from scratch:

https://bigprof.com/appgini/download-language-files

IMPORTANT:
==========
When translating, only translate the strings that are
TO THE RIGHT OF the arrow sign (=>).

Do NOT translate the strings between square brackets ([])
Also, leave the text between < and > untranslated.
And also, leave the special string %s as-is, untranslated.

=====================================================
PLEASE NOTE:
============
When a new version of AppGini is released, new strings
might be added to the "defaultLang.php" file. To translate
them, simply copy them to this file ("language.php") and 
translate them here. Do NOT translate them directly in 
the "defaultLang.php" file.
=====================================================

To avoid any error messages, please make sure to:

1. Add a comma at the end of each line if it's not already there.
2. Leave the last line in this file like this:
];

*/

$Translation = [
	'language' =>  'german',
	'admin area' =>  'Adminbereich',
	'rebuild fields' =>  'Sie könnten versuchen, dieses Problem selbst zu beheben. Adminbereich : Dienstprogramme : Felder neu aufbauen.',
	'sign out' =>  'Abmelden',
	'please wait' =>  'Bitte warten …',
	'no' =>  'Nein',
	'owner' =>  'Besitzer',
	'group' =>  'Anwendergruppe',
	'check availability' =>  'Prüfe Verfügbarkeit',
	'password' =>  'Kennwort',
	'confirm password' =>  'Kennwort-Bestätigung',
	'email' =>  'E-Mail-Adresse',
	'ok' =>  'OK',
	'username' =>  'Anwendername',
	'created' =>  'Erstellt',
	'delete record' =>  'Datensatz löschen',
	'maintenance mode admin notification' =>  'Der Wartungsmodus ist aktiv! Sie können ihn von der Admin-Startseite aus deaktivieren.',
	'select a table' =>  'Gehe zu …',
	'quick search' =>  'Suche',
	'records x to y of z' =>  'Datensatz <FirstRecord> bis <LastRecord> von <RecordCount>',
	'filters' =>  'Filter',
	'filter' =>  'Filter',
	'filtered field' =>  'Gefiltertes Feld',
	'comparison operator' =>  'Vergleichsoperator',
	'comparison value' =>  'Vergleichswert',
	'and' =>  'und',
	'or' =>  'oder',
	'equal to' =>  'gleich',
	'not equal to' =>  'ungleich',
	'greater than' =>  'größer als',
	'greater than or equal to' =>  'größer gleich',
	'less than' =>  'kleiner als',
	'less than or equal to' =>  'kleiner gleich',
	'like' =>  'wie/enthält',
	'not like' =>  'enthält nicht',
	'is empty' =>  'ist leer',
	'is not empty' =>  'ist nicht leer',
	'apply filters' =>  'Filter anwenden',
	'save filters' =>  'Filter speichern und anwenden',
	'saved filters title' =>  'HTML-Code des verwendeten Filters',
	'saved filters instructions' =>  'Kopieren Sie den Code und fügen Sie ihn in eine HTML-Datei ein. So können Sie später darauf zurückgreifen, ohne ihn neu zu definieren. Sie können die Datei auf ihrem Computer oder im Netzwerk speichern.',
	'hide code' =>  'Diesen Code verbergen',
	'printer friendly view' =>  'Druckansicht',
	'save as csv' =>  'Als CSV-Datei speichern',
	'edit filters' =>  'Filter bearbeiten',
	'clear filters' =>  'Filter zurücksetzen',
	'order by' =>  'Sortiere nach',
	'go to page' =>  'Gehe zu Seite:',
	'none' =>  'keine',
	'Select all records' =>  'Alle Datensätze auswählen',
	'With selected records' =>  'Ausgewählte Datensätze',
	'Print Preview Detail View' =>  'Voransicht Detail',
	'Print Preview Table View' =>  'Voransicht Tabelle',
	'Print' =>  'Drucken',
	'Cancel Printing' =>  'Abbrechen',
	'Cancel Selection' =>  'Auswahl aufheben',
	'Maximum records allowed to enable this feature is' =>  'Die maximale Anzahl Datensätze für diese Funktion ist ',
	'No matches found!' =>  'Keine Daten gefunden.',
	'Start typing to get suggestions' =>  'Zeichen eingeben, um Vorschläge zu erhalten.',
	'are you sure?' =>  'Diesen Datensatz wirklich löschen?',
	'add new record' =>  'Neuen Datensatz hinzufügen',
	'update record' =>  'Datensatz ändern',
	'deselect record' =>  'Datensatz abwählen',
	'couldn\'t delete' =>  "Konnte Datensatz nicht löschen, weil <RelatedRecords> Datensätze davon in Tabelle '<TableName>' abhängig sind.",
	'confirm delete' =>  "Dieser Datensatz hat <RelatedRecords> abhängige Datensätze in Tabelle '<TableName>'. Möchten Sie ihn trotzdem löschen? <Delete> &nbsp; <Cancel>",
	'yes' =>  'Ja',
	'pkfield empty' =>  'Das Feld ist ein Primärschlüsselfeld und darf nicht leer sein.',
	'upload image' =>  'Datei hochladen',
	'select image' =>  'Wählen Sie eine Datei',
	'remove image' =>  'Lösche Datei',
	'month names' =>  'Januar,Februar,März,April,Mai,Juni,Juli,August,September,Oktober,November,Dezember',
	'field not null' =>  'Dieses Feld darf nicht leer sein.',
	'*' =>  '*',
	'today' =>  'Heute',
	'Hold CTRL key to select multiple items from the above list.' =>  'Drücken Sie die Strg-Taste, um mehrere Einträge aus der Liste auszuwählen.',
	'Save New' =>  'Speichern',
	'Save As Copy' =>  'Speichern Kopie',
	'Deselect' =>  'Abbrechen',
	'Add New' =>  'Neu',
	'Delete' =>  'Löschen',
	'Cancel' =>  'Abbrechen',
	'Print Preview' =>  'Druckvorschau',
	'Save Changes' =>  'Speichern Änderungen',
	'CSV' =>  'CSV speichern',
	'Reset Filters' =>  'Filter aus',
	'Find It' =>  'Suchen',
	'Previous' =>  'Vorherige',
	'Next' =>  'Nächste',
	'Back' =>  'Zurück',
	'homepage' =>  'Startseite',
	'error:' =>  'Fehler:',
	'sql error:' =>  'SQL-Fehler:',
	'query:' =>  'SQL-Anfrage:',
	'< back' =>  '&lt; Zurück',
	'if you haven\'t set up' =>  "<br>Falls Sie die Datenbank noch nicht eingerichtet haben, können Sie das <a href='setup.php'>hier</a> tun.",
	'file too large' =>  'Fehler: Die Datei überschreitet die maximale Dateigröße; von <MaxSize> KB',
	'invalid file type' =>  'Fehler: Dieser Dateityp ist nicht erlaubt. Nur Dateien vom Typ <FileTypes> können auf den Server hochgeladen werden.',
	'goto start page' =>  'Zurück zur Startseite',
	'no db connection' =>  'Konnte keine Datenbankverbindung aufbauen.',
	'no db name' =>  "Kein Zugriff auf die Datenbank '<DBName>' auf diesem Server.",
	'provide connection data' =>  'Bitte geben Sie folgende Daten an, um sich mit der Datenbank zu verbinden:',
	'mysql server' =>  'MySQL Server (Host)',
	'mysql username' =>  'MySQL Benutzername',
	'mysql password' =>  'MySQL Kennwort',
	'mysql db' =>  'Databank Name',
	'connect' =>  'Verbinden',
	'setup performed' =>  'Setup wurde schon ausgeführt.',
	'delete md5' =>  "Wenn Sie das <b>Setup</b> noch einmal ausführen wollen, müssen Sie zuerst die Datei 'setup.md5' in diesem Verzeichnis löschen.",
	'table exists' =>  'Tabelle <b><TableName></b> existiert und enthält <NumRecords> Datensätze.',
	'failed' =>  'fehlgeschlagen',
	'mysql said' =>  'MySQL meldet:',
	'table uptodate' =>  'Tabelle ist aktuell.',
	'couldnt count' =>  'Konnte Datensätze der Tabelle <b><TableName></b> nicht zählen.',
	'creating table' =>  'Erzeuge Tabelle <b><TableName></b> …',
	'tableAccessDenied' =>  'Sie haben keine Zugriffsrechte für diese Tabelle. Wenden Sie sich bitte an den Administrator.',
	'not signed in' =>  'Sie sind nicht angemeldet.',
	'sign in' =>  'Anmelden',
	'signed as' =>  'Angemeldet als',
	'admin setup needed' =>  'Das Admin-Setup wurde noch nicht ausgeführt. Bitte melden Sie sich am <a href=admin/>Admin Control Panel</a> an, um das Setup auszuführen.',
	'db setup needed' =>  'Das Setup wurde noch nicht ausgeführt. Bitte melden Sie sich zuerst auf der <a href=setup.php>Setup-Seite</a> an.',
	'new record saved' =>  'Der neue Datensatz wurde gespeichert.',
	'record updated' =>  'Die Änderungen wurden gespeichert.',
	'login failed' =>  'Ihr Anmeldeversuch schlug fehl. Versuchen Sie es noch einmal.',
	'sign in here' =>  'Anmeldung',
	'remember me' =>  'Angemeldet bleiben',
	'go to signup' =>  'Sie haben keinen Anwendernamen? <br><a href=membership_signup.php>Registrieren Sie sich bitte!</a>',
	'forgot password' =>  'Kennwort vergessen? <a href=membership_passwordReset.php>Hier klicken</a>',
	'browse as guest' =>  'Oder klicken Sie <a href=index.php>hier</a>, um als Gast <br>weiterzuarbeiten.',
	'no table access' =>  'Ihre Berechtigungen sind unzureichend. Bitte melden Sie sich zuerst an.',
	'signup' =>  'Registrieren',
	'user already exists' =>  "Anwendername '<MemberID>' existiert schon. Wählen Sie einen anderen.",
	'user available' =>  "Anwendername '<MemberID>' ist verfügbar und Sie können ihn verwenden.",
	'empty user' =>  "Bitte geben Sie erst einen Anwendernamen ein. Klicken Sie dann auf 'Prüfe Verfügbarkeit'.",
	'thanks' =>  'Danke für die Anmeldung!',
	'sign in no approval' =>  'Wenn Sie eine Gruppe gewählt haben, die keine Administrator-Freigabe benötigt, können Sie sich jetzt <a href=index.php?signIn=1>hier</a> anmelden.',
	'sign in wait approval' =>  'Wenn Sie eine Gruppe gewählt haben, die eine Administrator-Freigabe benötigt, warten Sie bitte auf eine Bestätigung per E-Mail.',
	'username empty' =>  'Sie müssen einen Anwendernamen angeben. Bitte gehen Sie zurück und geben Sie einen Anwendernamen ein.',
	'password invalid' =>  'Sie müssen ein mind. 4-stelliges Kennwort eingeben. Leerzeichen sind nicht erlaubt. Bitte gehen Sie zurück und geben Sie ein gültiges Kennwort ein.',
	'password no match' =>  'Das Kennwort ist falsch. Gehen Sie zurück und korrigieren Sie das Kennwort.',
	'username exists' =>  'Der Anwendername existiert schon. Bitte gehen Sie zurück und wählen Sie einen anderen Anwendernamen.',
	'email invalid' =>  'Ungültige E-Mail-Adresse. Bitte gehen Sie zurück und korrigieren Sie Ihre E-Mail-Adresse.',
	'group invalid' =>  'Ungültige Gruppe. Bitte gehen Sie zurück und korrigieren Sie die Gruppenauswahl.',
	'sign up here' =>  'Hier registrieren',
	'registered? sign in' =>  'Schon registriert? <a href=index.php?signIn=1>Hier anmelden</a>.',
	'sign up disabled' =>  'Der Administrator hat die Registrierung deaktiviert. Versuchen Sie es später nochmals.',
	'groups *' =>  'Wenn Sie eine mit (*) markierte Gruppe gewählt haben, können Sie sich nicht anmelden, bis der Administrator Sie freigeschaltet hat. Sie erhalten dazu eine gesonderte E-Mail.',
	'sign up' =>  'Registrierung',
	'password reset' =>  'Kennwort zurücksetzen',
	'password reset details' =>  'Anwendername oder E-Mail-Adresse eingeben. Sie erhalten eine E-Mail mit einen Bestätigungslink. Dort können Sie Ihr neues Kennwort eingeben',
	'password reset subject' =>  'Anleitung zum Zurücksetzen des Kennworts',
	'password reset message' =>  "Lieber Anwender, \n\n zum Zurücksetzen oder Ändern Ihres Kennworts, klicken Sie auf diesen Link: \n <ResetLink> \n\n Falls Sie das Kennwort nicht ändern wollen, ignorieren Sie diese Nachricht.",
	'password reset ready' =>  'Eine E-Mail mit Hinweisen zum ändern Ihres Kennworts wurde an Ihre E-Mail-Adresse geschickt. Bitte lassen Sie dieses Browserfenster geöffnet und folgen Sie der Anleitung in der E-Mail.<br><br> Falls Sie keine E-Mail erhalten haben, schauen Sie in Ihrem Spam-Ordner nach oder versuchen Sie es erneut.',
	'password reset invalid' =>  'Ungültiger Anwendername oder ungültiges Kennwort. <a href=membership_passwordReset.php>Erneut versuchen</a>, oder <a href=index.php>zurück zur Startseite</a>.',
	'password change' =>  'Kennwort ändern',
	'new password' =>  'Neues Kennwort',
	'password reset done' =>  'Kennwort geändert. Sie können <a href=index.php?signOut=1>sich hier neu anmelden.</a>.',
	'No records found' =>  'Keine Datensätze gefunden.',
	'You can add children records after saving the main record first' =>  'Untergeordnete Datensätze können erst nach dem Speichern des Hauptdatensatzes angelegt werden.',
	'ascending' =>  'Aufsteigend',
	'descending' =>  'Absteigend',
	'then by' =>  'Dann nach',
	'Legend' =>  'Legende',
	'Table' =>  'Tabelle',
	'Edit' =>  'Bearbeiten',
	'View' =>  'Anzeigen',
	'Only your own records' =>  'Nur Ihre eigenen Datensätze',
	'All records owned by your group' =>  'Alle Datensätze Ihrer Anwendergruppe',
	'All records' =>  'Alle Datensätze',
	'Not allowed' =>  'Nicht erlaubt',
	'Your info' =>  'Ihr Profil',
	'Hello user' =>  'Hallo %s!',
	'Your access permissions' =>  'Ihre Zugriffsberechtigungen',
	'Update profile' =>  'Profil ändern',
	'Update password' =>  'Kennwort ändern',
	'Change your password' =>  'Ändern Sie Ihr Kennwort',
	'Old password' =>  'Altes Kennwort',
	'Password strength: weak' =>  'Kennwortsicherheit: schwach',
	'Password strength: good' =>  'Kennwortsicherheit: gut',
	'Password strength: strong' =>  'Kennwortsicherheit: sehr gut',
	'Wrong password' =>  'Falsches Kennwort',
	'Your profile was updated successfully' =>  'Ihr Profil wurde geändert',
	'Your password was changed successfully' =>  'Ihr Kennwort wurde geändert',
	'Your IP address' =>  'Ihre IP-Adresse',
	'Records to display' =>  'Anzuzeigende Datensätze',
	'Setup Data' =>  'Setup-Daten',
	'Database Information' =>  'Datenbank-Informationen',
	'Admin Information' =>  'Admin-Informationen',
	'setup intro 1' =>  'Wahrscheinlich gibt es keine Konfigurationsdatei. Sie ist notwendig, damit die Anwendung funktioniert. <br> Diese Setup-Seite wird Ihnen helfen, diese Datei zu erstellen. In einigen Serverkonfigurationen könnte das nicht funktionieren. In diesem Fall müssen Sie voraussichtlich die Zugriffsrechte ändern oder manuell die Konfigurationsdatei erstellen.',
	'setup intro 2' =>  'Willkommen in Ihrer neuen AppGini-Anwendung! Bevor Sie beginnen, benötigen wir einige Informationen über Ihre Datenbank. Sie müssen folgendes wissen, bevor Sie fortfahren: <ol> <li> Datenbankserver (Host) </ li> <li> Datenbankname </ li> <li> Datenbankbenutzernamen </ li> <li> Datenbank-Kennwort </ li> </ ol> Diese Informationen wurden Ihnen wahrscheinlich von Ihrem Web-Hosting-Anbieter zur Verfügung gestellt. Wenn diese Informationen nicht verfügbar sind, dann wenden Sie sich bitte an Ihren Web-Hosting-Anbieter oder schauen Sie in ihre Service-Dokumentation, bevor Sie hier weitermachen. Wenn Sie bereit sind, können Sie beginnen!',
	'setup finished' =>  '<b>Fertig!</ b> <br> Ihre AppGini-Anwendung wurde installiert. Hier sind einige Vorschläge, um anzufangen:',
	'setup next 1' =>  'Geben Sie Daten ein oder arbeiten Sie mit schon vorhandenen Daten.',
	'setup next 2' =>  'Importieren Sie vorhandene Daten aus einer CSV-Datei.',
	'setup next 3' =>  'Gehen Sie auf die Admin-Startseite, wo Sie die Anwendungseinstellungen ändern können.',
	'db_name help' =>  'Der Name der Datenbank für Ihre AppGini-Anwendung',
	'db_server help' =>  '<i>localhost</i> funktioniert auf den meisten Servern. Wenn nicht, wenden Sie sich an Ihren Web-Hosting-Anbieter.',
	'db_username help' =>  'Ihr MySQL-Benutzername.',
	'db_password help' =>  'Ihr MySQL-Kennwort',
	'username help' =>  'Geben Sie den Admin-Anwendernamen, die Sie verwenden wollen, um in den Admin-Bereich zu gelangen. Muss vier Zeichen oder länger sein.',
	'password help' =>  'Geben Sie für den Admin-Bereich ein starkes Kennwort ein.',
	'email help' =>  ' Geben Sie die E-Mail-Adresse, an die die Admin-Benachrichtigungen gesendet werden sollen, ein.',
	'Continue' =>  'Weitermachen …',
	'Lets go' =>  "OK, weiter geht's!",
	'Submit' =>  'Absenden',
	'Hide' =>  'Verbergen',
	'Database info is correct' =>  '&#10003; Datenbankinformationen sind richtig!',
	'Database connection error' =>  '&#10007; Datenbank-Verbindungsfehler!',
	'failed to create config instructions' =>  'Die Ursache hierfür sind höchstwahrscheinlich die Zugriffsrechte, die gesetzt sind, um das Erstellen von Dateien durch Ihren Web-Server zu verhindern. Keine Sorge! Sie können die Config-Datei manuell erstellen. <br> Fügen Sie einfach den folgenden Code in einen Texteditor ein und speichern Sie die Datei als "config.php", dann laden Sie sie per FTP oder eine andere Methode in den Ordner %s auf Ihren Server.',
	'Only show records having filterer' =>  'Nur Datensätze zeigen, in denen %s = %s ist.',
	'You don\'t have enough permissions to delete this record' =>  'Ihre Zugriffsrechte reichen nicht aus, um diesen Datensatz zu löschen.',
	'Couldn\'t delete this record' =>  'Dieser Datensatz konnte nicht gelöscht werden.',
	'The record has been deleted successfully' =>  'Der Datensatz wurde gelöscht ',
	"Couldn\'t save changes to the record" =>  'Änderungen am Datensatz konnten nicht gespeichert werden.',
	"Couldn\'t save the new record" =>  'Der neue Datensatz konnte nicht gespeichert werden.',
	'More' =>  'Mehr',
	'Confirm deleting multiple records' =>  'Bestätigen Sie das Löschen mehrerer Datensätze.',
	'<n> records will be deleted. Are you sure you want to do this?' =>  '<n> Datensätze werden gelöscht. Wollen Sie das wirklich tun?',
	'Yes, delete them!' =>  'Ja, bitte löschen!',
	'No, keep them.' =>  'Nein, bitte behalten.',
	'Deleting record <i> of <n>' =>  'Datensatz <i> von <n> löschen.',
	'Delete progress' =>  ' Fortschritt beim Löschen',
	'Show/hide details' =>  ' Details anzeigen/verbergen ',
	'Connection error' =>  'Verbindungsfehler',
	'Add more actions' =>  'Weitere Aktionen hinzufügen',
	'Update progress' =>  'Update-Fortschritt',
	'Change owner' =>  'Besitzer ändern',
	'Updating record <i> of <n>' =>  ' Datensatz <i> von <n> aktualisieren',
	'Change owner of <n> selected records to' =>  'Besitzer von <n> ausgewählten Datensätze ändern zu',
	'username invalid' =>  'Anwendername <MemberID> existiert schon oder ist ungültig. Bitte geben Sie einen Anwendernamen mit 4 bis 20 Zeichen ein.',
	'permalink' =>  'Permalink',
	'invalid provider' =>  'Ungültiger Anbieter!',
	'invalid url' =>  'Ungültige URL',
	'cant retrieve coordinates from url' =>  'URL-Bestandteile nicht gültig!',
	'unique field error' =>  'Dieser Wert existiert schon oder ist ungültig. Bitte geben Sie einen gültigen Wert ein.',
	'show all user records from table' =>  'Zeige alle Datensätze dieses Anwenders in der Tabelle "<tablename>"',
	'show all group records from table' =>  'Zeige alle Datensätze dieser Gruppe in der Tabelle "<tablename>"',
	'email this user' =>  'E-Mail an diesen Anwender senden',
	'email this group' =>  'E-Mail an diese Gruppe senden',
	'last modified' =>  'Letzte Änderung',
	'record has no owner' =>  'Dieser Datensatz hat keinen Besitzer. Sie können einen Besitzer im Admin-Bereich zuweisen.',
	'admin-only info' =>  'Die oben stehende Info wird angezeigt, weil Sie derzeit als Super-Admin angemeldet sind. Andere Anwender können die Info nicht sehen.',
	'discard changes confirm' =>  'Änderungen an diesem Datensatz verwerfen?',
	'hide/show columns' =>  'Spalten verbergen/zeigen',
	'next column' =>  'Nächste Spalte',
	'previous column' =>  'Vorherige Spalte',
	'hide all' =>  'Alle verbergen',
	'toggle' =>  'Umschalten',
	'datetimepicker locale' =>  'de',
	'account token theft warning' =>  'Jemand hat möglicherweise versucht, auf Ihr Anwender-Konto zuzugreifen. Sie sind jetzt abgemeldet und müssen sich neu anmelden.',
	'group added successfully' =>  'Gruppe erfolgreich hinzugefügt',
	'group updated successfully' =>  'Änderungen an dieser Gruppe erfolgreich gespeichert',
	'saved filter link' =>  'Gespeicherter Filter-Link',
	'app documentation' =>  'App Dokumentation',
	'back to top' =>  'Zurück nach oben',
	'check all' =>  'Alles anwählen',
	'uncheck all' =>  'Alles abwählen',
	'invert checks' =>  'Auswahl umkehren',
	'set all to x' =>  'Alle auf <x> setzen',
	'Jump to' =>  'Gehe zu …',
	'check username availability' =>  'Prüfe Verfügbarkeit',
	'try rebuild fields' =>  'Sie könnten versuchen, dieses Problem selbst zu beheben. Adminbereich : Dienstprogramme : Felder neu aufbauen.',



// ------ THE FOLLOWING LINES NEED TRANSLATION ------
// ------ Translated for APPGINI Version 5.91 -------
// ------ By Willi Renkens, Nov 11, 2000 ------------

	'membership management' =>  "Anwenderverwaltung",
	'password mismatch' =>  "Kennwörter stimmen nicht überein.",
	'error' =>  "Fehler",
	'invalid email' =>  "Ungültige E-Mail-Adresse",
	'sending mails' =>  "Das Versenden von E-Mails kann etwas dauern. Bitte schließen Sie diese Seite nicht, bis Sie die Meldung 'Abgeschlossen' sehen.",
	'complete step 4' =>  "Bitte schließen Sie Schritt 4 ab. Wählen sie den Anwender aus, dem Sie Datensätze zuweisen möchten.",
	'info' =>  "Info",
	'sure move member' =>  "Sind Sie sicher, dass Sie den Anwender '<MEMBER>' und dessen Daten von Gruppe '<OLDGROUP>' nach Gruppe '<NEWGROUP>' verschieben möchten?",
	'sure move data of member' =>  "Sind Sie sicher, dass Sie die Daten des Anwenders '<OLDMEMBER>' der Gruppe '<OLDGROUP>' zum Anwender '<NEWMEMBER>' der Gruppe '<NEWGROUP>' verschieben möchten?",
	'sure move all members' =>  "Sind Sie sicher, dass Sie alle Anwender und deren Daten von Gruppe '<OLDGROUP>' nach Gruppe '<NEWGROUP>' verschieben möchten?",
	'sure move data of all members' =>  "Sind Sie sicher, dass Sie die Daten aller Anwender der Gruppe '<OLDGROUP>' zum Anwender '<MEMBER>' der Gruppe '<NEWGROUP>' verschieben möchten?",
	'toggle navigation' =>  "Navigation umschalten",
	'groups' =>  "Gruppen",
	'view groups' =>  "Gruppen anzeigen",
	'add group' =>  "Gruppe hinzufügen",
	'edit anonymous permissions' =>  "Rechte anonymer Anwender bearbeiten",
	'members' =>  "Anwender",
	'view members' =>  "Anwender anzeigen",
	'add member' =>  "Anwender hinzufügen",
	"view member records"  =>  "Datensätze eines Anwenders anzeigen",
	'utilities' =>  "Dienstprogramme",
	'admin settings' =>  "Admin-Einstellungen",
	'rebuild thumbnails' =>  "Miniaturansichten neu erstellen",
	'import CSV' =>  "CSV-Daten importieren",
	'batch transfer' =>  "Batch-Transfer-Assistent",
	'mail all users' =>  "E-Mail an alle Anwender",
	'AppGini forum' =>  'AppGini Community Forum',
	"user's area" =>  'Anwenderbereich',
	'attention' =>  "Achtung!",
	'security risk admin' =>  'Sie verwenden den Standardbenutzernamen und das Kennwort des Administrators. Das ist ein enormes Sicherheitsrisiko. Bitte ändern Sie <em>umgehend</em> mindestens das Admin-Kennwort über die <a href="pageSettings.php">Admin-Einstellungsseite</a>.',
	'security risk' =>  'Sie verwenden das Standardkennwort für den Administrator. Das ist ein enormes Sicherheitsrisiko. Bitte ändern Sie <em>umgehend</em> das Admin-Kennwort über die <a href="pageSettings.php">Admin-Einstellungsseite</a>.',
	'plugins' =>  'Plugins',
	'assigned table records to group' =>  "<NUMBER> Datensätze der Tabelle '<TABLE>' der Gruppe '<GROUP>' zugeordnet",
	'assigned table records to group and member' =>  "<NUMBER> Datensätze der Tabelle '<TABLE>' der Gruppe '<GROUP> , Anwender '<MEMBERID>' zugeordnet",
	'data ownership assign' =>  "Besitz von Daten ohne Besitzer zuordnen",
	'records ownership done' =>  "Alle Datensätze in allen Tabellen haben nun einen Besitzer. <br>Zurück zur <a href='pageHome.php'>Admin-Startseite</a>.",
	'select group' =>  "Gruppe auswählen",
	'data ownership' =>  "Manchmal kann es vorkommen, dass Sie Tabellen mit Daten haben, die vor der Implementierung dieser AppGini-Anwendung eingegeben wurden, oder dass Sie diese Tabellen mit anderen Anwendungen angelegt haben, die das Verwaltungsystem von AppGini nicht kennen. Diese Daten haben derzeit keine Besitzer. Auf dieser Seite können Sie diesen Daten Besitzergruppen und Besitzern zuordnen.",
	'table' =>  "Tabelle",
	'records with no owners' =>  "Datensätze ohne Besitzer",
	'new owner group' =>  "Neue Besitzergruppe",
	'new owner member' =>  "Neuer Besitzer*",
	'cancel' =>  "Abbrechen",
	'assign new owners' =>  "Neue Besitzer zuordnen",
	'if no owner member assigned' =>  '* Wenn Sie hier keinen neuen Besitzer zuordnen, können Sie das zu einem späteren Zeitpunkt über den <a href="pageTransferOwnership.php">Batch-Transfer-Assistenten</a> erledigen.',
	'can not delete group remove members' =>  'Diese Gruppe kann nicht gelöscht werden. Bitte entfernen Sie zunächst die Anwender.',
	'can not delete group transfer records' =>  'Diese Gruppe kann nicht gelöscht werden. Bitte transferieren Sie zunächst die Datensätze in eine andere Gruppe …',
	'group exists error' =>  "Fehler: Gruppenname existiert bereits. Sie müssen einen eindeutigen Gruppennamen wählen.",
	'group not found error' =>  "Fehler: Gruppe nicht gefunden!",
	'edit group' =>  "Gruppe '<GROUPNAME>' bearbeiten",
	'add new group' =>  "Neue Gruppe hinzufügen",
	'anonymous group attention' =>  "ACHTUNG! Das ist die anonyme Gruppe.",
	'show tool tips' =>  "Tooltipps anzeigen, wenn die Maus über Optionen bewegt wird",
	'group name' =>  "Gruppenname",
	'readonly group name' =>  "Der Name der anonymen Gruppe ist hier schreibgeschützt.",
	'anonymous group name' =>  "Wenn Sie die Gruppe '<ANONYMOUSGROUP>' nennen, wird sie als anonyme Gruppe betrachtet, welche die Berechtigungen von Gastbesuchern definiert, die sich nicht am System anmelden.",
	'description' =>  "Beschreibung",
	'allow visitors sign up' =>  'Besuchern die Anmeldung erlauben?',
	'admin add users' =>  "Nein. Nur Administratoren können Anwender hinzufügen.",
	'admin approve users' =>  "Ja, aber der Administrator muss sie freischalten.",
	'automatically approve users' =>  "Ja, und sie werden automatisch freigeschaltet.",
	'group table permissions' =>  "Tabellenrechte für diese Gruppe",
	'all' =>  "Alle",
	'insert' =>  "Einfügen",
	'view' =>  "Anzeigen",
	'edit' =>  "Bearbeiten",
	'delete' =>  "Löschen",
	'save changes' =>  "Änderungen speichern",
	'username error' =>   "Fehler: Anwendername existiert bereits oder ist ungültig. Stellen Sie sicher, dass Sie einen Anwendernamen mit 4 bis 20 gültigen Zeichen eingegeben haben.",
	'member not found' =>   "Fehler: Anwender nicht gefunden!",
	'user has special permissions' =>   "Dieser Anwender hat spezielle Berechtigungen, die seine Gruppenberechtigungen überschreiben.",
	'user has group permissions' =>  'Dieser Anwender erbt die  <a href="pageEditGroup.php?groupID=<GROUPID>">Rechte seiner Gruppe.</a>.',
	'set user special permissions' =>  'Spezielle Berechtigungen für diesen Anwender setzen',
	'sure continue' =>  "Wenn Sie Änderungen an diesem Anwender vorgenommen und noch nicht gespeichert haben, gehen diese verloren, wenn Sie fortfahren. Wollen Sie wirklich fortfahren?",
	'edit member' =>  "Anwender <MEMBERID> bearbeiten",
	'add new member' =>  "Neuen Anwender hinzufügen",
	'anonymous guest member' =>  "Achtung! Das ist der anonyme (Gast-)Anwender.",
	'admin member' =>  'Achtung! Das ist der Admin-Anwender. Sie können den Anwendernamen, das Kennwort oder die E-Mail-Adresse dieses Anwenders hier nicht ändern, aber Sie können das auf der <a href="pageSettings.php">Admin-Einstellungsseite</a> tun.',
	'member username' =>  "Anwendername",
	'read only username' =>  "Der Anwendername des Gastes ist schreibgeschützt.",
	'change password' =>  "Geben Sie ein Kennwort nur dann ein, wenn Sie das Kennwort dieses Anwenders ändern möchten. Ansonsten lassen Sie dieses Feld leer.",
	'approved' =>  "Freigeschaltet?",
	'banned' =>  "Gesperrt?",
	'comments' =>  "Kommentare",
	'back to members' =>  "Zurück zu Anwender",
	'member added' =>  "Anwender <USERNAME> hinzugefügt",
	'member permissions saved' =>  "Die Anwenderrechte wurden gespeichert.",
	'member permissions reset' =>  "Die Anwenderrechte wurden auf die gleichen wie die in der zugehörigen Gruppe zurückgesetzt.",
	'user table permissions' =>  "Tabellenberechtigungen für Anwender <a href='pageEditMember.php? memberID=<MEMBER>' title='Anwenderdetails'><MEMBERID></a> der Gruppe <a href='pageEditGroup.php?groupID=<GROUPID>' title='Gruppendetails und -rechte' ><GROUP></a>",
	'no member permissions' =>  'Dieser Anwender hat momentan keine speziellen Berechtigungen. Diese Liste zeigt die Berechtigungen seiner Gruppe.',
	'reset member permissions' =>  "Anwenderrechte zurücksetzen",
	'remove special permissions' =>  'Dadurch werden alle speziellen Berechtigungen dieses Anwenders entfernt und er hat die gleichen Rechte wie seine Gruppe. Sind Sie sicher, dass Sie das wollen?',
	'invalid table' =>  "Ungültige Tabelle.",
	'invalid primary key' =>  "Ungültiger Primärschlüsselwert",
	'record not found' =>  "Datensatz nicht gefunden, wenn er extern importiert wurde, versuchen Sie, einen Besitzer aus dem Admin-Bereich zuzuweisen.",
	'invalid username' =>  "Ungültiger Anwendername",
	'record not found error' =>  "Fehler: Datensatz nicht gefunden!",
	'edit Record Ownership' =>  "Datensatz-Besitz bearbeiten",
	'owner group' =>  "Besitzergruppe",
	'view all records by group' =>  "Alle Einträge dieser Gruppe anzeigen",
	'owner member' =>  "Besitzer",
	'view all records by member' =>  "Alle Datensätze dieses Anwenders anzeigen",
	'switch record ownership' =>  "Wenn Sie den Besitz dieses Datensatzes auf einen Anwender einer anderen Gruppe umstellen möchten, müssen Sie zuerst die Besitzergruppe ändern und die Änderungen sichern.",
	'record created on' =>  "Datensatz erzeugt am",
	'record modified on' =>  "Datensatz geändert am",
	'view all records of table' =>  "Alle Datensätze dieser Tabelle anzeigen",
	'record data' =>  "Daten erfassen",
	'print' =>  "Drucken",
	'could not retrieve field list' =>  "Feldliste konnte nicht von '<TABLENAME>' abgerufen werden",
	'field name' =>  "Feldname",
	'value' =>  "Wert",
	'visitor sign up' =>  '<a href="../membership_signup.php" target="_blank">Besucher anmelden</a> ist deaktiviert, da es keine Gruppen gibt, in denen sich Besucher anmelden können. Um die Besucherregistrierung zu aktivieren, legen Sie mindestens eine Gruppe fest, um die Besucherregistrierung zu ermöglichen.',
	'table data without owner' =>  'Es befinden sich Daten in einer oder mehreren Tabellen, die keinen Besitzer haben. Um eine Besitzergruppe für diese Daten zuzuweisen, <a href="pageAssignOwners.php">klicken Sie hier</a>.',
	'membership management homepage' =>  'Homepage der Anwenderverwaltung',
	'newest updates' =>  "Neueste Updates",
	'view record details' =>  "Datensatzdetails anzeigen",
	'newest entries' =>  "Neueste Einträge",
	'available add-ons' =>  "Verfügbare Add-Ons",
	'more info' =>  "Mehr Info",
	'close' =>  "Schließen",
	'view add-ons' =>  "Add-Ons anzeigen",
	'top members' =>  "Top-Anwender",
	'edit member details' =>  "Anwenderdetails bearbeiten",
	'View member records' =>  "Anwenderdatensätze anzeigen",
	'records' =>  "Datensätze",
	'members stats' =>  'Anwender-Statistiken',
	'total groups' =>  "Gruppen insgesamt",
	'active members' =>  "Aktive Anwender",
	'view active members' =>  "Aktive Anwender anzeigen",
	'members awaiting approval' =>  "Anwender, die noch auf Freischaltung warten",
	'view members awaiting approval' =>  "Anwender anzeigen, die auf Freischaltung warten",
	'banned members' =>  "Gesperrte Anwender",
	'view banned members' =>  "Gesperrte Anwender anzeigen",
	'total members' =>  "Anwender gesamt",
	'view all members' =>  "Alle Anwender anzeigen",
	'BigProf tweets ' =>  "Tweets von BigProf Software",
	'follow BigProf' =>  "@bigprof folgen",
	'loading bigprof feed' =>  "@bigprof-Feed laden …",
	'remove feed' =>  "Diesen Feed entfernen",
	'can not send mail' =>  "Sie können derzeit keine E-Mails versenden. Die konfigurierte Absender-E-Mail-Adresse ist ungültig. Bitte <a href='pageSettings.php'>korrigieren Sie das zunächst</a> und versuchen Sie es dann erneut.",
	'all groups' =>  "Alle Gruppen",
	'no recipient' =>  "Empfänger konnte nicht gefunden werden. Bitte stellen Sie sicher, dass Sie einen gültigen Empfänger angeben.",
	'invalid subject line' =>  "Ungültige Betreffzeile",
	'no recipient found' =>  "Empfänger konnte nicht gefunden werden. Bitte stellen Sie sicher, dass Sie einen gültigen Empfänger angeben.",
	'mail queue not saved' =>  "Die Mail-Warteschlange konnte nicht gespeichert werden. Bitte stellen Sie sicher, dass das Verzeichnis '<CURRDIR>' beschreibbar ist (chmod 755 oder chmod 777).",
	'send mail' =>  "E-Mail-Nachricht an einen Anwender / eine Gruppe senden",
	'send mail to all members' =>  "Sie senden eine E-Mail an alle Anwender. Das kann viel Zeit in Anspruch nehmen und die Serverleistung beeinträchtigen. Wenn Sie eine große Anzahl von Anwendern haben, empfehlen wir Ihnen nicht, eine E-Mail an alle gleichzeitig zu senden.",
	'from' =>  "Von",
	'change setting' =>  "Diese Einstellung ändern",
	'to' =>  "An",
	'subject' =>  "Betreff",
	'message' =>  "Nachricht",
	'send message' =>  "Nachricht senden",
	'record details' => "Anwenderverwaltung -- Datensatzdetails",
	'table name' =>  "Tabelle: <TABLENAME>",
	'create or update table' =>  "Mit der Abfrage wurde versucht, das Feld <i><FIELD></i> in der Tabelle <i><TABLE></i> zu <ACTION>: <pre><QUERY></pre> Die Ergebnisse werden unten angezeigt.",
	'view or rebuild fields' =>  "Felder anzeigen/neu aufbauen",
	'show deviations only' =>  "Nur Abweichungen anzeigen",
	'show all fields' =>  "Alle Felder zeigen",
	'compare tables page' =>  "Diese Seite vergleicht die in AppGini entworfenen Tabellen- und Feldstrukturen/Schemata mit der tatsächlichen Datenbankstruktur und ermöglicht es Ihnen, Abweichungen zu korrigieren.",
	'field' =>  "Feld",
	'AppGini definition' =>  "Definition in AppGini",
	'database definition' =>  "Aktuelle Definition in der Datenbank",
	'table name title' =>  "Tabelle <TABLENAME>",
	'does not exist' =>  "existiert nicht!",
	'create field' =>  "Erstellen Sie das Feld durch Ausführen einer ADD COLUMN-Abfrage.",
	'create it' =>  "Erstellen",
	'fix field' =>  "Korrigieren Sie das Feld, indem Sie eine ALTER COLUMN-Abfrage ausführen, so dass die Definition des Feldes mit der in AppGini identisch ist.",
	'fix it' =>  "Korrigieren",
	'field update warning' =>  "GEFAHR!!! In einigen Fällen kann das zu Datenverlust, abgeschnittenen oder korrupten Datensätzen führen. Es ist vielleicht besser, das Feld in AppGini zu aktualisieren, damit es mit dem Feld in der Datenbank übereinstimmt. Möchten Sie trotzdem weitermachen?",
	'no deviations found' =>  "Keine Abweichungen gefunden. Alle Felder sind OK!",
	'error fields' =>  "<CREATENUM> nicht existierende Felder gefunden, die angelegt werden müssen. <br><UPDATENUM> abweichende Felder gefunden, die eventuell aktualisiert werden müssen.",
	'thumbnails utility' =>  "Verwenden Sie dieses Dienstprogramm, wenn Sie ein oder mehrere Bildfelder in einer Tabelle haben, in der keine Miniaturansichten oder Miniaturansichten mit falschen Abmessungen angezeigt werden.",
	'rebuild thumbnails of table' =>  'Miniaturansischt der Tabelle ',
	'rebuild' =>  "Neu aufbauen",
	'rebuild thumbnails of table_name' =>  "Miniaturansicht der '<i><TABLENAME></i>' Tabelle neu aufbauen …",
	'do not close page message' =>  "Schließen Sie diese Seite nicht, bis eine Bestätigungsmeldung angezeigt wird, dass alle Miniaturansichten erstellt wurden.",
	'rebuild thumbnails status' =>  "Status: Miniaturansichten werden immer noch neu aufgebaut, bitte warten …",
	'building field thumbnails' =>  "Miniaturansichten für' <i><FIELD></i>' -Feld erstellen …",
	'done' =>  "Fertig.",
	'finished status' =>  "Status: beendet. Sie können diese Seite jetzt schließen.",
	'invalid mail queue' =>  "Ungültige Mail-Warteschlange.",
	'sending message failed' =>  " -- Nachricht an '<EMAIL>' senden: fehlgeschlagen.",
	'sending message ok' =>  " -- Nachricht an' <EMAIL>' senden: Ok.",
	'done!' =>  "Erledigt!",
	'close page' =>  "Sie können diese Seite jetzt schließen oder zu einer anderen Seite wechseln.",
	'mail log' =>  "Mail-Protokoll:",
	'invalid security token' =>  'Ungültiges Sicherheitstoken! Bitte <a href="pageSettings.php"> die Seite </a> neu laden und erneut versuchen.',
	'unique admin username error' =>  "Der neue Admin-Anwendername wird bereits von einem anderen Anwender verwendet. Bitte stellen Sie sicher, dass der neue Admin-Anwendername eindeutig ist.",
	'unique anonymous username error' =>  'Der neue anonyme Anwendername wird bereits von einem anderen Anwender verwendet. Bitte stellen Sie sicher, dass der angegebene Anwendername eindeutig ist.',
	'unique anonymous group name error' =>  'Der neue anonyme Gruppenname wird bereits von einer anderen Gruppe verwendet. Bitte stellen Sie sicher, dass der angegebene Gruppenname eindeutig ist.',
	'admin password mismatch' =>  '"Admin-Kennwort" und "Kennwort bestätigen" stimmen nicht überein.',
	'invalid sender email' =>  'Ungültige "Absender-E-Mail-Adresse".',
	'errors occurred' =>  "Folgende Fehler sind aufgetreten:",
	'go back' =>  'Bitte <a href="pageSettings.php" onclick="history.go(-1); return false;">Zurück</a> korrigieren Sie die obigen Fehler und versuchen Sie es erneut.',
	'record updated automatically' =>  "Datensatz automatisch aktualisiert am <DATE>",
	'admin settings saved' =>  'Admin-Einstellungen gespeichert.<br>Zurück zu <a href="pageSettings.php">Admin-Einstellungen</a>.',
	'admin settings not saved' =>  'Admin-Einstellungen NICHT gespeichert. Fehlerursache: <ERROR><br>Zurück zu <a href="pageSettings.php" onclick="history.go(-1); return false;">Admin-Einstellungen</a>.',
	'admin username' =>  "Admin-Anwendername",
	'admin password' =>  "Admin-Kennwort",
	'change admin password' =>  "Geben Sie ein Kennwort nur dann ein, wenn Sie das Admin-Kennwort ändern möchten.",
	'sender email' =>  "E-Mail-Adresse des Senders",
	'sender name and email' =>  'Name und E-Mail des Senders werden beim Senden im "An"-Feld verwendet in',
	'email messages' =>  "E-Mails an Gruppen oder Anwender",
	'admin notifications' =>  "Admin-Benachrichtigungen",
	'no email notifications' =>  "Keine E-Mail-Benachrichtigungen an Admin",
	'member waiting approval' =>  "Administrator nur dann benachrichtigen, wenn ein neuer Anwender auf Freischaltung wartet.",
	'new sign-ups' =>  "Administrator über alle neuen Anmeldungen benachrichtigen.",
	'sender name' =>  "Name des Senders",
	'members custom field 1' =>  "Feld 1 für Anwenderinfo",
	'members custom field 2' =>  "Feld 2 für Anwenderinfo",
	'members custom field 3' =>  "Feld 3 für Anwenderinfo",
	'members custom field 4' =>  "Feld 4 für Anwenderinfo",
	'member approval email subject' =>  "Anwenderbestätigung<br>E-Mail-Betreff",
	'member approval email subject control' =>  "Wenn der Admin einen Anwender freischaltet, wird der Anwender per<br>E-Mail benachrichtigt, dass es freigeschaltet ist. Sie können den Betreff der<br>Freigabe-E-Mail in diesem Feld und den Inhalt in dem Feld unten einstellen.",
	'member approval email message' =>  "Anwenderbestätigung<br>E-Mail-Nachricht",
	'MySQL date' =>  "Datum-Format für MySQL",
	'MySQL reference' =>  'Bitte lesen Sie <a href="http://dev.mysql.com/doc/refman/5.0/en/date-and-time-functions.html#function_date-format" target="_blank">die MySQL-Referenz</a> für zulässige Formate.',
	'PHP short date' =>  "Kurzes Datum-Format für PHP",
	'PHP manual' =>  'Bitte lesen Sie <a href="http://www.php.net/manual/en/function.date.php" target="_blank">das PHP-Anwenderhandbuch</a> für zulässige Formate.',
	'PHP long date' =>  "Langes Datum-Format für PHP",
	'groups per page' =>  "Gruppen pro Seite",
	'members per page' =>  "Anwender pro Seite",
	'records per page' =>  "Datensätze pro Seite",
	'default sign-up mode' =>  "Standard-Registrierungsmodus<br>für neue Gruppen",
	'no sign-up allowed' =>  "Keine Anmeldung erlaubt. Nur der Administrator kann Anwender hinzufügen.",
	'admin approve members' =>  "Anmelden erlaubt, aber der Administrator muss Anwender freischalten.",
	'automatically approve members' =>  "Anmelden erlaubt, Anwender werden automatisch freigeschaltet.",
	'anonymous group' =>  "Name der anonymen<br>Gruppe",
	'anonymous user name' =>  "Name des anonymen<br>Anwenders",
	'hide twitter feed' =>  "Twitter-Feed auf Admin-Startseite ausblenden?",
	'twitter feed' =>  "Mit unserem Twitter-Feed halten wir Sie auf dem Laufenden über Neuigkeiten, nützliche Ressourcen, neue Versionen und viele weitere hilfreiche Tipps.",
	'invalid source member' =>  "Ungültiger Quell-Anwender ausgewählt.",
	'invalid destination member' =>  "Ungültiger Ziel-Anwender ausgewählt.",
	'moving member' =>  "Anwender '<MEMBERID>' und seine Daten aus Gruppe '<SOURCEGROUP>' zur Gruppe '<DESTINATIONGROUP>' verschieben …",
	'data records transferred' =>  "Anwender '<MEMBERID>' gehört jetzt zur Gruppe' <NEWGROUP>'. Anzahl transferierte Datensätze: <DATARECORDS>.",
	'moving data' =>  "Verschieben von Daten des Anwenders '<SOURCEMEMBER>' aus der Gruppe '<SOURCEGROUP>' nach '<DESTINATIONMEMBER>' aus der Gruppe '<DESTINATIONGROUP>' …",
	'member records status' =>  "Anwender '<SOURCEMEMBER>' der Gruppe '<SOURCEGROUP>' hatte <DATABEFORE> Datensätze. <TRANSFERSTATUS> zum Anwender '<DESTINATIONMEMBER>' der Gruppe '<DESTINATIONGROUP>'.",
	'moving all group members' =>  "Verschieben aller Anwender und Daten der Gruppe '<SOURCEGROUP>' in die Gruppe '<DESTINATIONGROUP>' …",
	'failed transferring group members' =>  "Aktion ist fehlgeschlagen. Es wurden keine Anwender von der Gruppe '<SOURCEGROUP>' nach '<DESTINATIONGROUP>' transferiert.",
	'group members transferred' =>  "Alle Anwender der Gruppe '<SOURCEGROUP>' gehören jetzt zur Gruppe '<DESTINATIONGROUP>'. ",
	'failed transfer data records' =>  "Die Übernahme von Datensätzen ist jedoch fehlgeschlagen.",
	'data records were transferred' =>  "<DATABEFORE> Datensätze wurden transferiert.",
	'moving group data to member' =>  "Verschieben von Daten aller Anwender der Gruppe '<SOURCEGROUP>' zum Anwender '<DESTINATIONMEMBER>' der Gruppe '<DESTINATIONGROUP>'…",
	'moving group data to member status' =>  "<NUMBER> Datensätze wurden von Gruppe '<SOURCEGROUP>' nach Anwender '<DESTINATIONMEMBER>' der Gruppe '<DESTINATIONGROUP>' transferiert.",
	'status' =>  'STATUS:',
	'batch transfer link' =>  'Um die gleiche Batchübernahme später noch einmal zu wiederholen, können Sie <a href= "pageTransferOwnership.php? Um die gleiche Batchübernahme später noch einmal zu wiederholen, können Sie <a href= "pageTransferOwnership.php?sourceGroupID=<SOURCEGROUP>&amp;sourceMemberID=<SOURCEMEMBER>&amp;destinationGroupID=<DESTINATIONGROUP>&amp;destinationMemberID=<DESTINATIONMEMBER>&amp;moveMembers=<MOVEMEMBERS>"> diesen Link mit einem Lesezeichen versehen oder kopieren</a>.',
	'ownership batch transfer' =>  "Batch-Transfer-Assistent",
	'step 1' =>  "SCHRITT 1:",
	'batch transfer wizard' =>  "Der Batch-Transfer-Assistent ermöglicht es Ihnen, Datensätze eines Anwenders oder aller Anwender einer Gruppe (die <i>Quellgruppe</i>) an einen Anwender einer anderen Gruppe (die <i>Zielgruppe</i>) zu transferieren.",
	'source group' =>  "Quellgruppe",
	'update' =>  "Aktualisieren",
	'next step' =>  'Nächster Schritt',
	'group statistics' =>  "Diese Gruppe hat <MEMBERS> Anwender und <RECORDS> Datensätze.",
	'step 2' =>  "SCHRITT 2:",
	'source member message' =>  "Quellbenutzer können ein einzelner Anwender oder alle Anwender der Quellgruppe sein.",
	'source member' =>  "Quellbenutzer",
	'all group members' =>  "Alle Anwender der Gruppe '<GROUPNAME>'",
	'member statistics' =>  "Dieser Anwender besitzt <RECORDS> Datensätze.",
	'step 3' =>  'STEP 3:',
	'destination group message' =>  "Die Zielgruppe kann sich von der Quellgruppe unterscheiden oder identisch sein. Nur Gruppen, die Anwender haben, sind unten aufgeführt.",
	'destination group' =>  "Zielgruppe",
	'step 4' =>  'STEP 4:',
	'destination member message' =>  "Der Zielanwender ist der neue Besitzer der Datensätze des Quellbenutzers.",
	'destination member' =>  "Zielbenutzer",
	'begin transfer' =>  "Transfer beginnen",
	'move records' =>  "Sie können entweder Datensätze aus dem/den Quellbenutzer/n in einen Anwender der Zielgruppe verschieben oder den/die Quellbenutzer zusammen mit seinen/ihren Datensätzen in die Zielgruppe verschieben …",
	'move data records to member' =>  "Datensätze zu diesem Anwender verschieben:",
	'move source member to group' =>  "Quellbenutzer und alle seinen/ihre Datensätze in die Gruppe '<GROUPNAME>' verschieben.",
	'file not found error' =>  "Fehler: Datei '<FILENAME>' nicht gefunden.",
	'preview and confirm CSV data' =>  "Vorschau und Bestätigung der CSV-Daten",
	'display csv file rows' =>  "Anzeige der ersten 10 Zeilen der CSV-Datei …",
	'change CSV settings' =>  'CSV-Einstellungen ändern',
	'import CSV data' =>  'Bestätigen und importieren Sie die CSV-Daten &gt,',
	'apply CSV settings' =>  'CSV-Einstellungen übernehmen',
	'importing CSV data' =>  'CSV-Daten importieren …',
	'start at estimated record' =>  "Beginnend mit Datensatz <RECORDNUMBER> von geschätzt <RECORDS> Datensätzen …",
	'table backed up' =>  "Tabelle '<TABLE>' gesichert als '<TABLENAME>'.",
	'table backup not done' =>  "Die Tabelle' <TABLE>' ist leer, es wurde deshalb keine Sicherung durchgeführt.",
	'importing batch' =>  'Importiere Batch <BATCH> von <BATCHNUM>: ',
	'records inserted or updated successfully' =>  "<RECORDS> Datensätze in <SECONDS> Sekunden eingefügt/aktualisiert.",
	'mission accomplished' =>  "Auftrag abgeschlossen!",
	'assign a records owner' =>  "Ordnen Sie den importierten Datensätzen einen Besitzer zu &gt,",
	'please wait and do not close' =>  "Bitte warten Sie und schließen Sie diese Seite nicht …",
	'hide advanced options' =>  "Erweiterte Optionen ausblenden",
	'show advanced options' =>  "Erweiterte Optionen anzeigen",
	'import CSV to database' =>  'Eine CSV-Datei in die Datenbank importieren',
	'import CSV to database page' =>  "Auf dieser Seite können Sie eine CSV-Datei (z. B. eine aus MS Excel generierte Datei) hochladen und in eine der Tabellen der Datenbank importieren. Das macht es sehr einfach, die Datenbank mit Daten aus anderen Quellen zu füllen, anstatt jeden einzelnen Datensatz manuell einzugeben.",
	'populate table from CSV' =>  "Das ist die Tabelle, die Sie mit Daten aus der CSV-Datei füllen möchten.",
	'CSV file' =>  "CSV-Datei",
	'preview CSV data' =>  "Vorschau CSV-Daten &gt,",
	'no table name provided' =>  "Kein Tabellenname angegeben.",
	'can not open CSV' =>  "Kann CSV-Datei '<FILENAME>' nicht öffnen.",
	'empty CSV file' =>  "Die CSV-Datei '<FILENAME>' ist leer.",
	'no CSV file data' =>  "Die CSV-Datei '<FILENAME>' enthält keine lesbaren Daten.",
	'field separator' =>  "Feldtrenner",
	'default comma' =>  "Die Vorgabe ist Komma (,)",
	'field delimiter' =>  "Feldbegrenzer",
	'default double-quote' =>  'Die Vorgabe ist ein doppeltes Anführungszeichen (")',
	'maximum characters per line' =>  "Maximale Anzahl von Zeichen pro Zeile",
	'trouble importing CSV' =>  "Wenn Sie Probleme beim Importieren der CSV-Datei haben, versuchen Sie, diesen Wert zu erhöhen.",
	'ignore lines number' =>  "Anzahl der zu ignorierenden Zeilen",
	'skip lines number' =>  "Ändern Sie diesen Wert, wenn Sie eine bestimmte Anzahl von Zeilen in der CSV-Datei überspringen möchten.",
	'first line field names' =>  "Die erste Zeile der Datei enthält Feldnamen",
	'field names must match' =>  "Feldnamen müssen <b>genau</b> mit den Feldnamen in der Datenbank übereinstimmen.",
	'update table records' =>  'Übereinstimmende Datensätze anhand des Primärschlüssels aktualisieren.',
	'ignore CSV table records' =>  "Wenn nicht markiert, werden Sätze in der CSV-Datei mit den gleichen Primärschlüsselwerten wie in der Tabelle <b>ignoriert</b>.",
	'back up the table' =>  "Sichern Sie die Tabelle vor dem Import von CSV-Daten in die Tabelle.",
	'no matching results found' =>  "Keine passenden Ergebnisse gefunden.",
	'search groups' =>  "Gruppen suchen",
	'find' =>  "Suchen",
	'reset' =>  "Zurücksetzen",
	'members count' =>  "Anzahl der Anwender",
	'Edit group' =>  "Gruppe bearbeiten",
	'confirm delete group' =>  "Sind Sie sicher, dass Sie diese Gruppe vollständig löschen möchten?",
	'delete group' =>  "Gruppe löschen",
	'view group records' =>  "Gruppen-Datensätze anzeigen",
	'view group members' =>  "Anwender dieser Gruppe anzeigen",
	'send message to group' =>  "Nachricht an Gruppe senden",
	'previous' =>  "Vorherige",
	'displaying groups' =>  "Gruppe <GROUPNUM1> bis <GROUPNUM2> von <GROUPS> anzeigen",
	'next' =>  "Nächste",
	'key' =>  "Schlüssel:",
	'edit group details' =>  "Gruppendetails und Berechtigungen bearbeiten",
	'add member to group' =>  "Einen neuen Anwender zur Gruppe hinzufügen",
	'view data records' =>  "Alle Datensätze der Gruppe anzeigen",
	'list group members' =>  "Alle Anwender einer Gruppe auflisten",
	'send email to all members' =>  "E-Mail-Nachricht an alle Anwender dieser Gruppe senden.",
	'search members' =>  "Anwender suchen <SEARCH> in <HTMLSELECT>",
	'all fields' =>  "Alle Felder",
	'any' =>  "Alle",
	'waiting approval' =>  "Warten auf Freischaltung",
	'active' =>  "Aktiv",
	'Banned' =>  "Gesperrt",
	'sign up date' =>  "Datum der Anmeldung",
	'Status' =>  'Status',
	'Edit member' =>  "Anwender bearbeiten",
	'sure delete user' =>  "Wollen Sie den Anwender '<USERNAME>' wirklich löschen?",
	'delete member' =>  "Anwender löschen",
	'approve this member' =>  "Diesen Anwender freischalten",
	'unban this member' =>  "Anwendersperre aufheben",
	'ban this member' =>  "Diesen Anwender sperren",
	"view members' records" =>  "Anwenderdatensätze anzeigen",
	'send message to member' =>  "Nachricht an Anwender senden",
	'displaying members' =>  "Anwender <MEMBERNUM1> bis <MEMBERNUM2> von <MEMBERS> anzeigen",
	'activate member' =>  "Neuen/gesperrten Anwender aktivieren",
	'ban member' =>  "Anwender sperren",
	'view entered member records' =>  "Alle Datensätze eines Anwenders anzeigen",
	'send email to member' =>  "E-Mail-Nachricht an einen Anwender senden",
	'data records' =>  "Datensätze",
	'show records' =>  "Datensätze anzeigen von",
	'all tables' =>  "Alle Tabellen",
	'sort records' =>  "Datensätze sortieren nach",
	'date created' =>  "Erstellt am",
	'date modified' =>  "Geändert am",
	'newer first' =>  "Neuere zuerst",
	'older first' =>  "Ältere zuerst",
	'modified' =>  "Geändert",
	'data' =>  "Daten",
	'change record ownership' =>  "Besitzer dieses Datensatzes ändern",
	'sure delete record' =>  "Sind Sie sicher, dass Sie diesen Datensatz löschen wollen?",
	'displaying records' =>  "Datensätze anzeigen von <RECORDNUM1> bis <RECORDNUM2> von <RECORDS>",
	'maintenance mode message' =>  'Meldung Wartungsmodus',
	'maintenance mode' =>  'Wartungsmodus',
	'OFF' =>  'AUS',
	'ON' =>  'AN',
	'enable maintenance mode?' =>  'Sind Sie sicher, dass Sie den Wartungsmodus einschalten möchten? In diesem Modus können nur Anwender mit Admin-Rechten auf die Site zugreifen!',
	'disable maintenance mode?' =>  'Sind Sie sicher, dass Sie den Wartungsmodus deaktivieren möchten? Alle Anwender können auf die Anwendung zugreifen!',
	'csv file upload error' =>  'Beim Verarbeiten der angeforderten CSV-Datei ist ein Fehler aufgetreten.',
	'back and retry' =>  'Zurück und erneut versuchen',
	'upload or choose csv file' =>  'Eine CSV-Datei hochladen oder eine bestehende Datei öffnen',
	'choose csv upload' =>  'Wählen Sie eine CSV-Datei zum Hochladen aus',
	'no file chosen yet' =>  'Keine Datei ausgewählt',
	'start upload' =>  'Upload starten',
	'error reading csv data' =>  'Beim Lesen von CSV-Daten ist ein Fehler aufgetreten. Versuchen Sie, die CSV-Einstellungen zurückzusetzen/einzustellen.',
	'belongs to' =>  'Gehört zu',
	'skip column' =>  'Diese Spalte überspringen',
	'connection failed retrying' =>  'Verbindung fehlgeschlagen. Wiederholung in <SECONDS> Sekunden …',
	'connection failed timeout' =>  'Zeitüberschreitung der Verbindung. Versuchen Sie es später noch einmal.',
	'sure delete csv' =>  'Sind Sie sicher, dass Sie die CSV-Datei [CSVFILE] vom Server löschen möchten?',
	'invalid csv file selected' =>  'Ungültige Datei ausgewählt. Muss eine CSV-Datei sein.',
	'couldnt delete csv file' =>  'Diese CSV-Datei konnte nicht gelöscht werden.',
	'error backing up table' =>  'Fehler: Konnte die Tabelle <TABLE> nicht sichern.',
	'no columns selected' =>  'Bitte wählen Sie mindestens eine Spalte aus und vergewissern Sie sich, dass jede ausgewählte Spalte zu einem UNIQUE-Feld gehört.',
	'csrf token expired or invalid' =>  'Upps! Bei dieser Seite ist etwas schief gelaufen. Bitte gehen Sie zurück und versuchen Sie es erneut.',
	'back to groups' =>  'Zurück zu Gruppen',
	'member updated' =>  "Anwender <USERNAME> aktualisiert",
	'fix errors before submitting' =>  'Bitte korrigieren Sie die hervorgehobenen Fehler vor dem Absenden der Seite!',
	'mail_function' =>  'Methode zum Senden von E-Mails',
	'smtp_server' =>  'SMTP Server',
	'smtp_encryption' =>  'SMTP Verschlüsselung',
	'smtp_port' =>  'SMTP Port',
	'smtp_port_hint' =>  'Typische Werte sind 25 (für unverschlüsseltes SMTP), 465 (in vielen Fällen mit SSL-Verschlüsselung) oder 587 (typisch mit TLS-Verschlüsselung).',
	'smtp_user' =>  'SMTP Anwendername',
	'smtp_pass' =>  'SMTP Kennwort',
	'configure mail settings' =>  'E-Mail-Einstellungen konfigurieren',
	'display debugging info' =>  'Debugging-Info anzeigen',
	'debugging info hint' =>  'Debugging-Informationen sind nützlich, wenn Sie Probleme beim Versenden von E-Mails über den konfigurierten SMTP-Server haben.',
	'create backup file' =>  'Backup-Datei erstellen',
	'database backups' =>  'Datenbank-Backups',
	'no backups found' =>  'Keine Backups gefunden. Klicken Sie auf "Backup-Datei erstellen", um ein Backup zu erstellen.',
	'available backups' =>  'Vorhandene Backups',
	'restore backup' =>  'Wiederherstellen',
	'delete backup' =>  'Löschen',
	'backup restored' =>  'Backup wurde wiederhergestellt.',
	'backup deleted' =>  'Backup wurde gelöscht.',
	'restore error' =>  'Beim Wiederherstellen des Backups ist ein Fehler aufgetreten.',
	'backup delete error' =>  'Beim Löschen des Backups ist ein Fehler aufgetreten.',
	'confirm delete backup' =>  'Wollen Sie dieses Backup wirklich löschen?',
	'confirm restore' =>  'Beim Wiederherstellen der Datenbank von einem Backup werden alle Daten einschließlich der Anwender und Kennwörter überschrieben. Die Datenbank wird auf den Stand zurückgesetzt, als das Backup gemacht wurde.\n\nWährend des Wiederherstellens wird der Wartungsmodus aktiviert, damit keine Daten unabsichtlich verändert werden können. Der Wartungsmodus wird nach dem Beenden der Wiederherstellung wieder ausgeschaltet .\n\nWollen Sie weitermachen?',
	'confirm backup' =>  'Während des Backups wird der Wartungsmodus aktiviert, damit keine Daten unabsichtlich verändert werden können. Der Wartungsmodus wird nach dem Beenden des Backups wieder ausgeschaltet .\n\nWollen Sie weitermachen?',
	'cant create backup folder' =>  'Fehler: Admin- und/oder Backup-Ordner sind schreibgeschützt. Bitte überprüfen Sie Ihre Zugriffsrechte oder wenden Sie sich an den Administrator.',
	'fix all' =>  'ALLE FELDER REPARIEREN',
	'backup before fix' =>  'Es wird empfohlen, vor dem Reparieren der Felder ein Datenbank-Backup zu machen.',
	'about backups' =>  'Backups werden mit dem Befehlszeilen-Tool MYSQLDUMP gemacht. Wenn keine Backups erstellt werden können, liegt es vielleicht daran, dass keine Erlaubnis besteht, MYSQLDUMP auszuführen.',
	'server status disabled' =>  'Die Funktion Server-Status ist in dieser Anwendung nicht aktiviert. Um sie zu aktivieren, schalten Sie die Option "Allow admin access to server status page" ein und generieren Sie die Anwendung neu.',
	'server status' =>  'Server-Status',
	'db status' =>  'Datenbank-Status',
	'generated by' =>  'Diese Anwendung wurde mit AppGini <VERSION> am <DATETIME> generiert.',
	'column table name' =>  'Tabellen-Name',
	'db storage' =>  'Datenbank-Speicher',
	'column size kb' =>  'Größe (KB)',
	'total' =>  'Total',
	'php info' =>  'PHP-Info',
	'files' =>  'Dateien',
	'uploads info' =>  'Upload-Info',
	'Loading ...' =>  'Beim Laden …',
	'The following errors occured' =>  'Folgende Fehler sind aufgetreten',
	'tip check csv for errors' =>  'Tipp: Sie können überprüfen, ob die CSV-Datei fehlerhaft ist, mit <a href="https://csvlint.io/" target="_blank">csvlint.io</a>',
	'keyboard shortcuts' =>  'Tastatur-Kürzel',
	'keyboard shortcuts disabled' =>  'Tastatur-Kürzel sind deaktiviert',
	'keyboard shortcuts enabled' =>  'Tastatur-Kürzel sind aktiviert',
	'Enable' =>  'Aktivieren',
	'Disable' =>  'Deaktivieren',
	'display this help window' =>  'Dieses Hilfe-Fenster anzeigen',
	'close this window' =>  'Dieses Fenster schließen',
	'open x navigation menu' =>  '<b><x></b>-Navigations-Menü öffnen',
	'user profile' =>  'Anwender-Profil',
	'clear search' =>  'Suchparameter löschen',
	'navigate between sections of page' =>  'Navigieren innerhalb der Seitenabschnitte',
	'open admin info menu' =>  'Admin-Informations-Menü öffnen',
	'navigate between sections of child records' =>  'Navigieren innerhalb der Abschnitte der abhängigen Datensätze',
	'old php version' =>  "Sie verwenden die PHP-Version <PHP_VERSION>. Diese Anwendung benötigt jedoch mindestens die  Version <minPHP>. Bitte machen Sie ein PHP-Upgrade oder installieren Sie die Anwendung auf einem anderen Server.",
	'extension not enabled' =>  "Diese Anwendung läuft nicht, weil die Erweiterung <EXTENSION> nicht aktiviert ist. Bitte aktivieren Sie sie in der Konfigurationsdatei php.ini, starten Sie den Webserver neu und versuchen Sie es erneut.",
	'error reading csv file' =>  'Fehler beim Lesen der CSV-Datei. Bitte stellen Sie sicher, dass die Datei existiert und das die CSV-Einstellungen korrekt sind.',
	'clean csv dir error' =>  'Konnte das Verzeichnis "import-csv" nicht lesen oder darin schreibwen.',
	'Invalid import job' =>  'Ungültiger Import-Job',
	'Previous record' =>  'Voriger Datensatz',
	'Next record' =>  'Nächster Datensatz',
	'job in progress by another process' =>  'Job läuft bereits in einem anderen Prozess',
	'invalid clean csv file' =>  'CSV-Datei ungültig, unlesbar oder nicht bereit',
	'invalid csv map' =>  'Ungültige Zurodnung der CSV-Felder',
	'invalid field separator' =>  'Ungültiger Feldtrenner',
	'import csv file' =>  'CSV-Daten in eine Tabelle importieren',
	'import another csv file' =>  'Eine weitere CSV-Datei importieren',
	'file upload error' =>  'Fehler beim Hochladen der Datei',
	'to use tab' =>  'Um das Tab-Zeichen als Feldseparator zu verwenden, schreiben Sie TAB',
	'field qualifier' =>  'Feldbegrenzer',
	'auto-detect csv columns' =>  'CSV-Spalten anhand der gewählten Tabelle automatisch bestimmen.',
	'nothing to import' =>  'Es sind keine Daten zum Importieren vorhanden. Bitte wählen Sie mindestens eine Spalte für den Import aus.',
	'multiple columns mapped to same field' =>  "Sie können nicht mehrere Felder in dasselbe Feld importieren.",
	'uploading in x seconds' =>  'Upload beginnt in [SECONDS] Sekunden.',
	'cancel and back to csv upload' =>  'Abbrechen und andere CSV-Datei auswählen',
	'confirm importing csv' =>  'Import der CSV-Daten in die ausgewählte Tabelle bestätigen',
	'total records' =>  'Datensätze gesamt',
	'imported records' =>  'Importierte Datensätze',
	'remaining' =>  'Verbleibend',
	'ETA' =>  'Fertig in',
	'import finished' =>  'Import abgeschlossen. Sie können auf die importierten Datensätze in der gewählten Tabelle zugreifen.',
	'import job taking long keep page open permalink' =>  'Dieser Import braucht längere Zeit. Sie können diesen geöffnet halten und in einem anderen Tab weiterarbeiten. Bitte kopieren Sie den unten stehenden Link, damit Sie den Import wieder neu aufsetzen können, falls etwas schiefgeht.',
	'pause' =>  'Pause',
	'resume' =>  'Fortfahren',
	'new' =>  'Neu',
	'updated' =>  'Aktualisiert',
	'skipped' =>  'Übersprungen',
	'fast import mode' =>  'Schneller Import-Modus (Statistiken weniger genau, Besitz der Datensätze wird erst nach dem Import gesetzt).',
	'assign owner for n records in table' =>  'Benutzer für [n] Datensätze ohne Besitzer in dieser Tabelle zuordnen',
	'no update missing pk field in csv' =>  "Bearbeiten ist deaktiviert, weil in der CSV-Datei kein Primärschlüssel angegeben ist. Oder Sie haben nicht das Recht, diese Tabelle zu bearbeiten.",
	'no insert update only' =>  "Sie haben nicht das Recht, neue Datensätze in diese Tabelle einzufügen. Sie dürfen sie nur aktualisieren.",
	'allow importing CSV files' =>  'Import von CSV-Dateien erlauben',
	'description of import CSV files option' =>  'Diese Option erlaubt es Anwendern, CSV-Dateien in Tabellen zu importieren, für die sie die Rechte Einfügen oder Aktualisieren besitzen.',
	'admin group attention' =>  'Achtung. Das ist die Admin-Gruppe.',
	'toggle import logs' =>  'Protokoll-Dateien für den Import anzeigen/verbergen',
	'admin csv warning'=> 'Diese Seite wird in zukünftigen Versionen nicht mehr verfügbar sein. Sie sollten stattdessen die neue Seite [a]CSV-Datei importieren[/a] verwenden.',

// ------ Translated for APPGINI Version 5.91 - 5.93 -------
// ------ By Willi Renkens, Jan 22, 2021 ------------
    'Jump to' => 'Gehe zu …',
	'check username availability' => 'Prüfen ob, dieser Anwendername verfügbar ist',
	'try rebuild fields' => 'Sie könnten dieses Problem im Administrationsbereich -> Dienstprogramme -> Felder anzeigen/neu aufbauen beheben.',
	'click continue if slow' => 'Wenn diese Seite zu lange zum Laden benötigt, klicken Sie auf [a]Weitermachen …[/a] um fortzufahren.',

	// Added in 5.91
	'keyboard shorcuts reference' => 'Tastaturkürzel-Übersicht',

	// Added in 5.93
	'google API key' => 'Google API Schlüssel',
	'google API key instructions' => 'Google API Schlüssel: So erhalten und konfigurieren Sie ihn',
	'base upload path' => 'Basisverzeichnis für Upload',
	'base upload path change warning' => 'Wenn Sie das Basisverzeichnis für Upload ändern, können Sie in der Anwendung nicht mehr auf bestehende hochgeladene Daten oder Bilder zugreifen. Sie müssen sie vorher in das neue Basisverzeichnis für Upload verschieben.',
	'base upload path instructions' => 'Das Verzeichnis, in dem hochgeladene Daten oder Bilder gespeichert werden. Das Verzeichnis ist relativ zum Anwendungsverzeichnis, aber Sie können dem Verzeichnisnamen <code>../</code> voranstellen,  um ein Verzeichnis außerhalb der Anwendung auszuwählen.',
	'invalid upload path' => 'Das angegebene Basisverzeichnis für Upload ist nicht vorhanden und konnte nicht angelegt werden.',
	'Appearance' => 'Aussehen',
	'Mail' => 'E-Mail',
	'Preconfigured users and groups' => 'Vorkonfigurierte Anwender und Gruppen',
	'Application' => 'Anwendung',

	// ------ Translated for APPGINI Version - 5.97 -------
	// ------ By Willi Renkens, June 20, 2021 ------------
	// Added in 5.97
	'Query logs' => 'Abfrage-Protokolle',
	'Query log table does not exist' => 'Fehler beim Erstellen der Tabelle mit den Abfrage-Protokollen. Bitte vergewissern Sie sich, dass die Datenbank das Privileg CREATE TABLE hat.',
	'slow queries' => 'Langsame Abfragen',
	'error queries' => 'Fehlerhafte Abfragen',
	'date/time' => 'Datum/Zeit',
	'duration (sec)' => 'Dauer (in Sek)',
	'page address' => 'Adresse der Seite',
	'query' => 'Abfrage',
	'page x of y' => 'Seite <x> von <y>',
	'total # queries' => 'Gesamtanzahl Abfragen: #, ',

	// ------ Translated for APPGINI Version - 6 -------
	// ------ By Willi Renkens, Nov 2, 2021 ------------
	// Added in 6.0
	'Interactive SQL queries tool' => 'Interaktives SQL-Abfrage-Tool',
	'Enter SQL query' => 'SQL-Abfrage eingeben',
	'Query must start with select' => 'Abfrage muss mit %s beginnen',
	'Display results' => 'Ausgabe anzeigen',
	'Update results as you type' => 'Ausgabe während des Tippens aktualisieren',
	'Use cache' => 'Cache verwenden',
	'results truncated' => 'Die Ausgabe kann aus Performance-Gründen nach %s Datensätzen abgeschnitten sein.',
	'Results will be displayed here' => 'Die Ausgabe wird hier angezeigt.',
	'Bookmark this query' => 'Diese Abfrage als Lesezeichen speichern',
	'Query name' => 'Name der Abfrage',
	'Manage bookmarked queries' => 'Lesezeichen verwalten',
];
