<?php
	define('PREPEND_PATH', '');
	include_once(__DIR__ . '/lib.php');

	// accept a record as an assoc array, return transformed row ready to insert to table
	$transformFunctions = [
		'flugbuch_verein' => function($data, $options = []) {
			if(isset($data['datum'])) $data['datum'] = guessMySQLDateTime($data['datum']);
			if(isset($data['flugplatz'])) $data['flugplatz'] = pkGivenLookupText($data['flugplatz'], 'flugbuch_verein', 'flugplatz');
			if(isset($data['mfbo'])) $data['mfbo'] = pkGivenLookupText($data['mfbo'], 'flugbuch_verein', 'mfbo');
			if(isset($data['erfasst'])) $data['erfasst'] = guessMySQLDateTime($data['erfasst']);
			if(isset($data['geaendert'])) $data['geaendert'] = guessMySQLDateTime($data['geaendert']);

			return $data;
		},
		'flugplaetze_oe' => function($data, $options = []) {

			return $data;
		},
		'mfbo' => function($data, $options = []) {

			return $data;
		},
	];

	// accept a record as an assoc array, return a boolean indicating whether to import or skip record
	$filterFunctions = [
		'flugbuch_verein' => function($data, $options = []) { return true; },
		'flugplaetze_oe' => function($data, $options = []) { return true; },
		'mfbo' => function($data, $options = []) { return true; },
	];

	/*
	Hook file for overwriting/amending $transformFunctions and $filterFunctions:
	hooks/import-csv.php
	If found, it's included below

	The way this works is by either completely overwriting any of the above 2 arrays,
	or, more commonly, overwriting a single function, for example:
		$transformFunctions['tablename'] = function($data, $options = []) {
			// new definition here
			// then you must return transformed data
			return $data;
		};

	Another scenario is transforming a specific field and leaving other fields to the default
	transformation. One possible way of doing this is to store the original transformation function
	in GLOBALS array, calling it inside the custom transformation function, then modifying the
	specific field:
		$GLOBALS['originalTransformationFunction'] = $transformFunctions['tablename'];
		$transformFunctions['tablename'] = function($data, $options = []) {
			$data = call_user_func_array($GLOBALS['originalTransformationFunction'], [$data, $options]);
			$data['fieldname'] = 'transformed value';
			return $data;
		};
	*/

	@include(__DIR__ . '/hooks/import-csv.php');

	$ui = new CSVImportUI($transformFunctions, $filterFunctions);
