<?php

// Data functions (insert, update, delete, form) for table flugplaetze_oe

// This script and data application was generated by AppGini, https://bigprof.com/appgini
// Download AppGini for free from https://bigprof.com/appgini/download/

function flugplaetze_oe_insert(&$error_message = '') {
	global $Translation;

	// mm: can member insert record?
	$arrPerm = getTablePermissions('flugplaetze_oe');
	if(!$arrPerm['insert']) {
		$error_message = $Translation['no insert permission'];
		return false;
	}

	$data = [
		'flugplatznummer' => Request::val('flugplatznummer', ''),
		'artikel_16' => Request::val('artikel_16', 'Ja'),
		'artikel16' => Request::fileUpload('artikel16', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'artikel16', Request::val('SelectedID'));
			},
		]),
		'mfbo' => Request::fileUpload('mfbo', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'mfbo', Request::val('SelectedID'));
			},
		]),
		'richtlinie' => Request::fileUpload('richtlinie', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'richtlinie', Request::val('SelectedID'));
			},
		]),
		'flugplatzordnung' => Request::fileUpload('flugplatzordnung', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'flugplatzordnung', Request::val('SelectedID'));
			},
		]),
		'verhaltensregeln' => Request::fileUpload('verhaltensregeln', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'verhaltensregeln', Request::val('SelectedID'));
			},
		]),
		'sonstige_datei' => Request::fileUpload('sonstige_datei', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'sonstige_datei', Request::val('SelectedID'));
			},
		]),
		'vereinsname' => Request::val('vereinsname', ''),
		'bundesland' => Request::val('bundesland', ''),
		'webseite' => br2nl(Request::val('webseite', '')),
		'telefon' => Request::val('telefon', ''),
		'vorname' => Request::val('vorname', ''),
		'nachname' => Request::val('nachname', ''),
		'email' => Request::val('email', ''),
		'zvr' => Request::val('zvr', ''),
		'flughoehe' => Request::val('flughoehe', ''),
		'mtom' => Request::val('mtom', ''),
		'google_map' => Request::val('google_map', ''),
		'open_street_map' => br2nl(Request::val('open_street_map', '')),
		'acg_map' => br2nl(Request::val('acg_map', '')),
		'flugbereich' => Request::fileUpload('flugbereich', [
			'maxSize' => 2048000,
			'types' => 'doc|docx|docm|odt|pdf|xls|xlsx|zip|jpg|jpeg|gif|png',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'flugbereich', Request::val('SelectedID'));
			},
		]),
		'bild1' => Request::fileUpload('bild1', [
			'maxSize' => 4096000,
			'types' => 'jpg|jpeg|gif|png|webp',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild1', 'tv'));
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild1', 'dv'));
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'bild1', Request::val('SelectedID'));
			},
		]),
		'bild2' => Request::fileUpload('bild2', [
			'maxSize' => 4096000,
			'types' => 'jpg|jpeg|gif|png|webp',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild2', 'tv'));
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild2', 'dv'));
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'bild2', Request::val('SelectedID'));
			},
		]),
		'bild3' => Request::fileUpload('bild3', [
			'maxSize' => 4096000,
			'types' => 'jpg|jpeg|gif|png|webp',
			'noRename' => false,
			'dir' => '',
			'success' => function($name, $selected_id) {
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild3', 'tv'));
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild3', 'dv'));
			},
			'failure' => function($selected_id, $fileRemoved) {
				if(!strlen(Request::val('SelectedID'))) return '';

				/* for empty upload fields, when saving a copy of an existing record, copy the original upload field */
				return existing_value('flugplaetze_oe', 'bild3', Request::val('SelectedID'));
			},
		]),
		'kontrollzone' => Request::val('kontrollzone', ''),
		'besonderheit' => Request::val('besonderheit', ''),
		'beschreibung' => br2nl(Request::val('beschreibung', '')),
		'erfasser' => parseCode('<%%creatorUsername%%>', true),
		'erfasst' => parseCode('<%%creationDateTime%%>', true),
	];

	// record owner is current user
	$recordOwner = getLoggedMemberID();

	$recID = tableInsert('flugplaetze_oe', $data, $recordOwner, $error_message);

	// if this record is a copy of another record, copy children if applicable
	if(strlen(Request::val('SelectedID')) && $recID !== false)
		flugplaetze_oe_copy_children($recID, Request::val('SelectedID'));

	return $recID;
}

function flugplaetze_oe_copy_children($destination_id, $source_id) {
	global $Translation;
	$requests = []; // array of curl handlers for launching insert requests
	$eo = ['silentErrors' => true];
	$safe_sid = makeSafe($source_id);
	$currentUsername = getLoggedMemberID();
	$errorMessage = '';

	// launch requests, asynchronously
	curl_batch($requests);
}

function flugplaetze_oe_delete($selected_id, $AllowDeleteOfParents = false, $skipChecks = false) {
	// insure referential integrity ...
	global $Translation;
	$selected_id = makeSafe($selected_id);

	// mm: can member delete record?
	if(!check_record_permission('flugplaetze_oe', $selected_id, 'delete')) {
		return $Translation['You don\'t have enough permissions to delete this record'];
	}

	// hook: flugplaetze_oe_before_delete
	if(function_exists('flugplaetze_oe_before_delete')) {
		$args = [];
		if(!flugplaetze_oe_before_delete($selected_id, $skipChecks, getMemberInfo(), $args))
			return $Translation['Couldn\'t delete this record'] . (
				!empty($args['error_message']) ?
					'<div class="text-bold">' . strip_tags($args['error_message']) . '</div>'
					: ''
			);
	}

	// child table: flugbuch_verein
	$res = sql("SELECT `id` FROM `flugplaetze_oe` WHERE `id`='{$selected_id}'", $eo);
	$id = db_fetch_row($res);
	$rires = sql("SELECT COUNT(1) FROM `flugbuch_verein` WHERE `flugplatz`='" . makeSafe($id[0]) . "'", $eo);
	$rirow = db_fetch_row($rires);
	$childrenATag = '<a class="alert-link" href="flugbuch_verein_view.php?filterer_flugplatz=' . urlencode($id[0]) . '">%s</a>';
	if($rirow[0] && !$AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation["couldn't delete"];
		$RetMsg = str_replace('<RelatedRecords>', sprintf($childrenATag, $rirow[0]), $RetMsg);
		$RetMsg = str_replace(['[<TableName>]', '<TableName>'], sprintf($childrenATag, 'flugbuch_verein'), $RetMsg);
		return $RetMsg;
	} elseif($rirow[0] && $AllowDeleteOfParents && !$skipChecks) {
		$RetMsg = $Translation['confirm delete'];
		$RetMsg = str_replace('<RelatedRecords>', sprintf($childrenATag, $rirow[0]), $RetMsg);
		$RetMsg = str_replace(['[<TableName>]', '<TableName>'], sprintf($childrenATag, 'flugbuch_verein'), $RetMsg);
		$RetMsg = str_replace('<Delete>', '<input type="button" class="btn btn-danger" value="' . html_attr($Translation['yes']) . '" onClick="window.location = `flugplaetze_oe_view.php?SelectedID=' . urlencode($selected_id) . '&delete_x=1&confirmed=1&csrf_token=' . urlencode(csrf_token(false, true)) . (Request::val('Embedded') ? '&Embedded=1' : '') . '`;">', $RetMsg);
		$RetMsg = str_replace('<Cancel>', '<input type="button" class="btn btn-success" value="' . html_attr($Translation[ 'no']) . '" onClick="window.location = `flugplaetze_oe_view.php?SelectedID=' . urlencode($selected_id) . (Request::val('Embedded') ? '&Embedded=1' : '') . '`;">', $RetMsg);
		return $RetMsg;
	}

	sql("DELETE FROM `flugplaetze_oe` WHERE `id`='{$selected_id}'", $eo);

	// hook: flugplaetze_oe_after_delete
	if(function_exists('flugplaetze_oe_after_delete')) {
		$args = [];
		flugplaetze_oe_after_delete($selected_id, getMemberInfo(), $args);
	}

	// mm: delete ownership data
	sql("DELETE FROM `membership_userrecords` WHERE `tableName`='flugplaetze_oe' AND `pkValue`='{$selected_id}'", $eo);
}

function flugplaetze_oe_update(&$selected_id, &$error_message = '') {
	global $Translation;

	// mm: can member edit record?
	if(!check_record_permission('flugplaetze_oe', $selected_id, 'edit')) return false;

	$data = [
		'flugplatznummer' => Request::val('flugplatznummer', ''),
		'artikel_16' => Request::val('artikel_16', ''),
		'artikel16' => Request::fileUpload('artikel16', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'artikel16', $selected_id);
			},
		]),
		'mfbo' => Request::fileUpload('mfbo', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'mfbo', $selected_id);
			},
		]),
		'richtlinie' => Request::fileUpload('richtlinie', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'richtlinie', $selected_id);
			},
		]),
		'flugplatzordnung' => Request::fileUpload('flugplatzordnung', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'flugplatzordnung', $selected_id);
			},
		]),
		'verhaltensregeln' => Request::fileUpload('verhaltensregeln', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'verhaltensregeln', $selected_id);
			},
		]),
		'sonstige_datei' => Request::fileUpload('sonstige_datei', [
			'maxSize' => 15360000,
			'types' => 'txt|doc|docx|docm|odt|pdf|rtf',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'sonstige_datei', $selected_id);
			},
		]),
		'vereinsname' => Request::val('vereinsname', ''),
		'bundesland' => Request::val('bundesland', ''),
		'webseite' => br2nl(Request::val('webseite', '')),
		'telefon' => Request::val('telefon', ''),
		'vorname' => Request::val('vorname', ''),
		'nachname' => Request::val('nachname', ''),
		'email' => Request::val('email', ''),
		'zvr' => Request::val('zvr', ''),
		'flughoehe' => Request::val('flughoehe', ''),
		'mtom' => Request::val('mtom', ''),
		'google_map' => Request::val('google_map', ''),
		'open_street_map' => br2nl(Request::val('open_street_map', '')),
		'acg_map' => br2nl(Request::val('acg_map', '')),
		'flugbereich' => Request::fileUpload('flugbereich', [
			'maxSize' => 2048000,
			'types' => 'doc|docx|docm|odt|pdf|xls|xlsx|zip|jpg|jpeg|gif|png',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'flugbereich', $selected_id);
			},
		]),
		'bild1' => Request::fileUpload('bild1', [
			'maxSize' => 4096000,
			'types' => 'jpg|jpeg|gif|png|webp',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild1', 'tv'));
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild1', 'dv'));
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'bild1', $selected_id);
			},
		]),
		'bild2' => Request::fileUpload('bild2', [
			'maxSize' => 4096000,
			'types' => 'jpg|jpeg|gif|png|webp',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild2', 'tv'));
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild2', 'dv'));
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'bild2', $selected_id);
			},
		]),
		'bild3' => Request::fileUpload('bild3', [
			'maxSize' => 4096000,
			'types' => 'jpg|jpeg|gif|png|webp',
			'noRename' => false,
			'dir' => '',
			'id' => $selected_id,
			'success' => function($name, $selected_id) {
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild3', 'tv'));
				Thumbnail::create($name, getThumbnailSpecs('flugplaetze_oe', 'bild3', 'dv'));
			},
			'removeOnRequest' => true,
			'remove' => function($selected_id) {
				// do nothing: preserve removed files on server.
			},
			'failure' => function($selected_id, $fileRemoved) {
				if($fileRemoved) return '';
				return existing_value('flugplaetze_oe', 'bild3', $selected_id);
			},
		]),
		'kontrollzone' => Request::val('kontrollzone', ''),
		'besonderheit' => Request::val('besonderheit', ''),
		'beschreibung' => br2nl(Request::val('beschreibung', '')),
		'geaendert_von' => parseCode('<%%editorUsername%%>', false),
		'geaendert' => parseCode('<%%editingDateTime%%>', false),
	];

	if($data['flugplatznummer'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Nummer des Flugplatzes': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	if($data['vereinsname'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Vereinsname': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	// get existing values
	$old_data = getRecord('flugplaetze_oe', $selected_id);
	if(is_array($old_data)) {
		$old_data = array_map('makeSafe', $old_data);
		$old_data['selectedID'] = makeSafe($selected_id);
	}

	$data['selectedID'] = makeSafe($selected_id);

	// hook: flugplaetze_oe_before_update
	if(function_exists('flugplaetze_oe_before_update')) {
		$args = ['old_data' => $old_data];
		if(!flugplaetze_oe_before_update($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$set = $data; unset($set['selectedID']);
	foreach ($set as $field => $value) {
		$set[$field] = ($value !== '' && $value !== NULL) ? $value : NULL;
	}

	if(!update(
		'flugplaetze_oe',
		backtick_keys_once($set),
		['`id`' => $selected_id],
		$error_message
	)) {
		echo $error_message;
		echo '<a href="flugplaetze_oe_view.php?SelectedID=' . urlencode($selected_id) . "\">{$Translation['< back']}</a>";
		exit;
	}


	update_calc_fields('flugplaetze_oe', $data['selectedID'], calculated_fields()['flugplaetze_oe']);

	// hook: flugplaetze_oe_after_update
	if(function_exists('flugplaetze_oe_after_update')) {
		if($row = getRecord('flugplaetze_oe', $data['selectedID'])) $data = array_map('makeSafe', $row);

		$data['selectedID'] = $data['id'];
		$args = ['old_data' => $old_data];
		if(!flugplaetze_oe_after_update($data, getMemberInfo(), $args)) return;
	}

	// mm: update record update timestamp
	set_record_owner('flugplaetze_oe', $selected_id);
}

function flugplaetze_oe_form($selectedId = '', $allowUpdate = true, $allowInsert = true, $allowDelete = true, $separateDV = true, $templateDV = '', $templateDVP = '') {
	// function to return an editable form for a table records
	// and fill it with data of record whose ID is $selectedId. If $selectedId
	// is empty, an empty form is shown, with only an 'Add New'
	// button displayed.

	global $Translation;
	$eo = ['silentErrors' => true];
	$noUploads = $row = $urow = $jsReadOnly = $jsEditable = $lookups = null;
	$noSaveAsCopy = true;
	$hasSelectedId = strlen($selectedId) > 0;

	// mm: get table permissions
	$arrPerm = getTablePermissions('flugplaetze_oe');
	$allowInsert = ($arrPerm['insert'] ? true : false);
	$allowUpdate = $hasSelectedId && check_record_permission('flugplaetze_oe', $selectedId, 'edit');
	$allowDelete = $hasSelectedId && check_record_permission('flugplaetze_oe', $selectedId, 'delete');

	if(!$allowInsert && !$hasSelectedId)
		// no insert permission and no record selected
		// so show access denied error -- except if TVDV: just hide DV
		return $separateDV ? $Translation['tableAccessDenied'] : '';

	if($hasSelectedId && !check_record_permission('flugplaetze_oe', $selectedId, 'view'))
		return $Translation['tableAccessDenied'];

	// print preview?
	$dvprint = $hasSelectedId && Request::val('dvprint_x') != '';

	$showSaveNew = !$dvprint && ($allowInsert && !$hasSelectedId);
	$showSaveChanges = !$dvprint && $allowUpdate && $hasSelectedId;
	$showDelete = !$dvprint && $allowDelete && $hasSelectedId;
	$showSaveAsCopy = !$dvprint && ($allowInsert && $hasSelectedId && !$noSaveAsCopy);
	$fieldsAreEditable = !$dvprint && (($allowInsert && !$hasSelectedId) || ($allowUpdate && $hasSelectedId) || $showSaveAsCopy);


	// populate filterers, starting from children to grand-parents

	// unique random identifier
	$rnd1 = ($dvprint ? rand(1000000, 9999999) : '');
	// combobox: artikel_16
	$combo_artikel_16 = new Combo;
	$combo_artikel_16->ListType = 0;
	$combo_artikel_16->MultipleSeparator = ', ';
	$combo_artikel_16->ListBoxHeight = 10;
	$combo_artikel_16->RadiosPerLine = 1;
	if(is_file(__DIR__ . '/hooks/flugplaetze_oe.artikel_16.csv')) {
		$artikel_16_data = addslashes(implode('', @file(__DIR__ . '/hooks/flugplaetze_oe.artikel_16.csv')));
		$combo_artikel_16->ListItem = array_trim(explode('||', entitiesToUTF8(convertLegacyOptions($artikel_16_data))));
		$combo_artikel_16->ListData = $combo_artikel_16->ListItem;
	} else {
		$combo_artikel_16->ListItem = array_trim(explode('||', entitiesToUTF8(convertLegacyOptions("Ja;;Nein"))));
		$combo_artikel_16->ListData = $combo_artikel_16->ListItem;
	}
	$combo_artikel_16->SelectName = 'artikel_16';
	// combobox: kontrollzone
	$combo_kontrollzone = new Combo;
	$combo_kontrollzone->ListType = 0;
	$combo_kontrollzone->MultipleSeparator = ', ';
	$combo_kontrollzone->ListBoxHeight = 10;
	$combo_kontrollzone->RadiosPerLine = 1;
	if(is_file(__DIR__ . '/hooks/flugplaetze_oe.kontrollzone.csv')) {
		$kontrollzone_data = addslashes(implode('', @file(__DIR__ . '/hooks/flugplaetze_oe.kontrollzone.csv')));
		$combo_kontrollzone->ListItem = array_trim(explode('||', entitiesToUTF8(convertLegacyOptions($kontrollzone_data))));
		$combo_kontrollzone->ListData = $combo_kontrollzone->ListItem;
	} else {
		$combo_kontrollzone->ListItem = array_trim(explode('||', entitiesToUTF8(convertLegacyOptions("Ja;;Nein"))));
		$combo_kontrollzone->ListData = $combo_kontrollzone->ListItem;
	}
	$combo_kontrollzone->SelectName = 'kontrollzone';

	if($hasSelectedId) {
		if(!($row = getRecord('flugplaetze_oe', $selectedId))) {
			return error_message($Translation['No records found'], 'flugplaetze_oe_view.php', false);
		}
		$combo_artikel_16->SelectedData = $row['artikel_16'];
		$combo_kontrollzone->SelectedData = $row['kontrollzone'];
		$urow = $row; /* unsanitized data */
		$row = array_map('safe_html', $row);
	} else {
		$filterField = Request::val('FilterField');
		$filterOperator = Request::val('FilterOperator');
		$filterValue = Request::val('FilterValue');
		$combo_artikel_16->SelectedText = (isset($filterField[1]) && $filterField[1] == '3' && $filterOperator[1] == '<=>' ? $filterValue[1] : entitiesToUTF8('Ja'));
		$combo_kontrollzone->SelectedText = (isset($filterField[1]) && $filterField[1] == '27' && $filterOperator[1] == '<=>' ? $filterValue[1] : entitiesToUTF8(''));
	}
	$combo_artikel_16->Render();
	$combo_kontrollzone->Render();

	ob_start();
	?>

	<script>
		// initial lookup values

		$j(function() {
			setTimeout(function() {
			}, 50); /* we need to slightly delay client-side execution of the above code to allow AppGini.ajaxCache to work */
		});
	</script>
	<?php

	$lookups = str_replace('__RAND__', $rnd1, ob_get_clean());


	// code for template based detail view forms

	// open the detail view template
	if($dvprint) {
		$template_file = is_file("./{$templateDVP}") ? "./{$templateDVP}" : './templates/flugplaetze_oe_templateDVP.html';
		$templateCode = @file_get_contents($template_file);
	} else {
		$template_file = is_file("./{$templateDV}") ? "./{$templateDV}" : './templates/flugplaetze_oe_templateDV.html';
		$templateCode = @file_get_contents($template_file);
	}

	// process form title
	$templateCode = str_replace('<%%DETAIL_VIEW_TITLE%%>', 'Flugplatz in &#214;sterreich', $templateCode);
	$templateCode = str_replace('<%%RND1%%>', $rnd1, $templateCode);
	$templateCode = str_replace('<%%EMBEDDED%%>', (Request::val('Embedded') ? 'Embedded=1' : ''), $templateCode);
	// process buttons
	if($showSaveNew) {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-success" id="insert" name="insert_x" value="1"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save New'] . '</button>', $templateCode);
	} elseif($showSaveAsCopy) {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="insert" name="insert_x" value="1"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save As Copy'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '', $templateCode);
	}

	// 'Back' button action
	if(Request::val('Embedded')) {
		$backAction = 'AppGini.closeParentModal(); return false;';
	} else {
		$backAction = 'return true;';
	}

	if($hasSelectedId) {
		if(!Request::val('Embedded')) $templateCode = str_replace('<%%DVPRINT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="dvprint" name="dvprint_x" value="1" title="' . html_attr($Translation['Print Preview']) . '"><i class="glyphicon glyphicon-print"></i> ' . $Translation['Print Preview'] . '</button>', $templateCode);
		if($allowUpdate)
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '<button type="submit" class="btn btn-success btn-lg" id="update" name="update_x" value="1" title="' . html_attr($Translation['Save Changes']) . '"><i class="glyphicon glyphicon-ok"></i> ' . $Translation['Save Changes'] . '</button>', $templateCode);
		else
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);

		if($allowDelete)
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '<button type="submit" class="btn btn-danger" id="delete" name="delete_x" value="1" title="' . html_attr($Translation['Delete']) . '"><i class="glyphicon glyphicon-trash"></i> ' . $Translation['Delete'] . '</button>', $templateCode);
		else
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);

		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '<button type="submit" class="btn btn-default ltr" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);

		// if not in embedded mode and user has insert only but no view/update/delete,
		// remove 'back' button
		if(
			$allowInsert
			&& !$allowUpdate && !$allowDelete && !$arrPerm['view']
			&& !Request::val('Embedded')
		)
			$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '', $templateCode);
		elseif($separateDV)
			$templateCode = str_replace(
				'<%%DESELECT_BUTTON%%>',
				'<button
					type="submit"
					class="btn btn-default ltr"
					id="deselect"
					name="deselect_x"
					value="1"
					onclick="' . $backAction . '"
					title="' . html_attr($Translation['Back']) . '">
						<i class="glyphicon glyphicon-chevron-left"></i> ' .
						$Translation['Back'] .
				'</button>',
				$templateCode
			);
		else
			$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '', $templateCode);
	}

	// set records to read only if user can't insert new records and can't edit current record
	if(!$fieldsAreEditable) {
		$jsReadOnly = '';
		$jsReadOnly .= "\t\$j('#flugplatznummer').replaceWith('<div class=\"form-control-static\" id=\"flugplatznummer\">' + (\$j('#flugplatznummer').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#artikel_16').replaceWith('<div class=\"form-control-static\" id=\"artikel_16\">' + (\$j('#artikel_16').val() || '') + '</div>'); \$j('#artikel_16-multi-selection-help').hide();\n";
		$jsReadOnly .= "\t\$j('#artikel16').parent().replaceWith(`<div class=\"form-control-static\" id=\"artikel16\">\${\$j('#artikel16').val() || ''}\${\$j('#artikel16').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#artikel16').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#mfbo').parent().replaceWith(`<div class=\"form-control-static\" id=\"mfbo\">\${\$j('#mfbo').val() || ''}\${\$j('#mfbo').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#mfbo').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#richtlinie').parent().replaceWith(`<div class=\"form-control-static\" id=\"richtlinie\">\${\$j('#richtlinie').val() || ''}\${\$j('#richtlinie').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#richtlinie').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#flugplatzordnung').parent().replaceWith(`<div class=\"form-control-static\" id=\"flugplatzordnung\">\${\$j('#flugplatzordnung').val() || ''}\${\$j('#flugplatzordnung').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#flugplatzordnung').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#verhaltensregeln').parent().replaceWith(`<div class=\"form-control-static\" id=\"verhaltensregeln\">\${\$j('#verhaltensregeln').val() || ''}\${\$j('#verhaltensregeln').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#verhaltensregeln').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#sonstige_datei').parent().replaceWith(`<div class=\"form-control-static\" id=\"sonstige_datei\">\${\$j('#sonstige_datei').val() || ''}\${\$j('#sonstige_datei').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#sonstige_datei').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#vereinsname').replaceWith('<div class=\"form-control-static\" id=\"vereinsname\">' + (\$j('#vereinsname').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#bundesland').replaceWith('<div class=\"form-control-static\" id=\"bundesland\">' + (\$j('#bundesland').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#webseite').parent().replaceWith(`<div class=\"form-control-static\" id=\"webseite\">\${\$j('#webseite').val() || ''}\${\$j('#webseite').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#webseite').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#telefon').replaceWith('<div class=\"form-control-static\" id=\"telefon\">' + (\$j('#telefon').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#vorname').replaceWith('<div class=\"form-control-static\" id=\"vorname\">' + (\$j('#vorname').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#nachname').replaceWith('<div class=\"form-control-static\" id=\"nachname\">' + (\$j('#nachname').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#email').parent().replaceWith(`<div class=\"form-control-static\" id=\"email\">\${\$j('#email').val() || ''}\${\$j('#email').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"mailto:' + \$j('#email').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-envelope\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#zvr').replaceWith('<div class=\"form-control-static\" id=\"zvr\">' + (\$j('#zvr').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#flughoehe').replaceWith('<div class=\"form-control-static\" id=\"flughoehe\">' + (\$j('#flughoehe').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#mtom').replaceWith('<div class=\"form-control-static\" id=\"mtom\">' + (\$j('#mtom').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#google_map').replaceWith('');\n";
		$jsReadOnly .= "\t\$j('#google_map, #google_map-edit-link').hide();\n";
		$jsReadOnly .= "\t\$j('#open_street_map').parent().replaceWith(`<div class=\"form-control-static\" id=\"open_street_map\">\${\$j('#open_street_map').val() || ''}\${\$j('#open_street_map').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#open_street_map').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#acg_map').parent().replaceWith(`<div class=\"form-control-static\" id=\"acg_map\">\${\$j('#acg_map').val() || ''}\${\$j('#acg_map').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#acg_map').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#flugbereich').parent().replaceWith(`<div class=\"form-control-static\" id=\"flugbereich\">\${\$j('#flugbereich').val() || ''}\${\$j('#flugbereich').val() ? '<a target=\"_blank\" class=\"hspacer-lg\" href=\"' + \$j('#flugbereich').val() + '\" target=\"_blank\"><i class=\"glyphicon glyphicon-globe\"></i></a>' : ''}</div>`);\n";
		$jsReadOnly .= "\t\$j('#bild1').replaceWith('<div class=\"form-control-static\" id=\"bild1\">' + (\$j('#bild1').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#bild2').replaceWith('<div class=\"form-control-static\" id=\"bild2\">' + (\$j('#bild2').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#bild3').replaceWith('<div class=\"form-control-static\" id=\"bild3\">' + (\$j('#bild3').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#kontrollzone').replaceWith('<div class=\"form-control-static\" id=\"kontrollzone\">' + (\$j('#kontrollzone').val() || '') + '</div>'); \$j('#kontrollzone-multi-selection-help').hide();\n";
		$jsReadOnly .= "\t\$j('#besonderheit').replaceWith('<div class=\"form-control-static\" id=\"besonderheit\">' + (\$j('#besonderheit').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('#beschreibung').replaceWith('<div class=\"form-control-static\" id=\"beschreibung\">' + (\$j('#beschreibung').val() || '') + '</div>');\n";
		$jsReadOnly .= "\t\$j('.select2-container').hide();\n";

		$noUploads = true;
	} else {
		// temporarily disable form change handler till time and datetime pickers are enabled
		$jsEditable = "\t\$j('form').eq(0).data('already_changed', true);";
		$jsEditable .= "\t\$j('form').eq(0).data('already_changed', false);"; // re-enable form change handler
	}

	// process combos
	$templateCode = str_replace('<%%COMBO(artikel_16)%%>', $combo_artikel_16->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(artikel_16)%%>', $combo_artikel_16->SelectedData, $templateCode);
	$templateCode = str_replace('<%%COMBO(kontrollzone)%%>', $combo_kontrollzone->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(kontrollzone)%%>', $combo_kontrollzone->SelectedData, $templateCode);

	/* lookup fields array: 'lookup field name' => ['parent table name', 'lookup field caption'] */
	$lookup_fields = [];
	foreach($lookup_fields as $luf => $ptfc) {
		$pt_perm = getTablePermissions($ptfc[0]);

		// process foreign key links
		if(($pt_perm['view'] && isDetailViewEnabled($ptfc[0])) || $pt_perm['edit']) {
			$templateCode = str_replace("<%%PLINK({$luf})%%>", '<button type="button" class="btn btn-default view_parent" id="' . $ptfc[0] . '_view_parent" title="' . html_attr($Translation['View'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-eye-open"></i></button>', $templateCode);
		}

		// if user has insert permission to parent table of a lookup field, put an add new button
		if($pt_perm['insert'] /* && !Request::val('Embedded')*/) {
			$templateCode = str_replace("<%%ADDNEW({$ptfc[0]})%%>", '<button type="button" class="btn btn-default add_new_parent" id="' . $ptfc[0] . '_add_new" title="' . html_attr($Translation['Add New'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-plus text-success"></i></button>', $templateCode);
		}
	}

	// process images
	$templateCode = str_replace('<%%UPLOADFILE(id)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(flugplatznummer)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(artikel_16)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(artikel16)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="artikel16" id="artikel16" data-filetypes="txt|doc|docx|docm|odt|pdf|rtf" data-maxsize="15360000" style="max-width: calc(100% - 1.5rem);" accept=".txt,.doc,.docx,.docm,.odt,.pdf,.rtf">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(mfbo)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="mfbo" id="mfbo" data-filetypes="txt|doc|docx|docm|odt|pdf|rtf" data-maxsize="15360000" style="max-width: calc(100% - 1.5rem);" accept=".txt,.doc,.docx,.docm,.odt,.pdf,.rtf">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['mfbo'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(mfbo)%%>', '<input type="checkbox" name="mfbo_remove" id="mfbo_remove" value="1"> <label for="mfbo_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(mfbo)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(richtlinie)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="richtlinie" id="richtlinie" data-filetypes="txt|doc|docx|docm|odt|pdf|rtf" data-maxsize="15360000" style="max-width: calc(100% - 1.5rem);" accept=".txt,.doc,.docx,.docm,.odt,.pdf,.rtf">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['richtlinie'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(richtlinie)%%>', '<input type="checkbox" name="richtlinie_remove" id="richtlinie_remove" value="1"> <label for="richtlinie_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(richtlinie)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(flugplatzordnung)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="flugplatzordnung" id="flugplatzordnung" data-filetypes="txt|doc|docx|docm|odt|pdf|rtf" data-maxsize="15360000" style="max-width: calc(100% - 1.5rem);" accept=".txt,.doc,.docx,.docm,.odt,.pdf,.rtf">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['flugplatzordnung'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(flugplatzordnung)%%>', '<input type="checkbox" name="flugplatzordnung_remove" id="flugplatzordnung_remove" value="1"> <label for="flugplatzordnung_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(flugplatzordnung)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(verhaltensregeln)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="verhaltensregeln" id="verhaltensregeln" data-filetypes="txt|doc|docx|docm|odt|pdf|rtf" data-maxsize="15360000" style="max-width: calc(100% - 1.5rem);" accept=".txt,.doc,.docx,.docm,.odt,.pdf,.rtf">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['verhaltensregeln'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(verhaltensregeln)%%>', '<input type="checkbox" name="verhaltensregeln_remove" id="verhaltensregeln_remove" value="1"> <label for="verhaltensregeln_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(verhaltensregeln)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(sonstige_datei)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="sonstige_datei" id="sonstige_datei" data-filetypes="txt|doc|docx|docm|odt|pdf|rtf" data-maxsize="15360000" style="max-width: calc(100% - 1.5rem);" accept=".txt,.doc,.docx,.docm,.odt,.pdf,.rtf">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['sonstige_datei'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(sonstige_datei)%%>', '<input type="checkbox" name="sonstige_datei_remove" id="sonstige_datei_remove" value="1"> <label for="sonstige_datei_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(sonstige_datei)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(vereinsname)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(bundesland)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(webseite)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(telefon)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(vorname)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(nachname)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(email)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(zvr)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(flughoehe)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(mtom)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(google_map)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(open_street_map)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(acg_map)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(flugbereich)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="flugbereich" id="flugbereich" data-filetypes="doc|docx|docm|odt|pdf|xls|xlsx|zip|jpg|jpeg|gif|png" data-maxsize="2048000" style="max-width: calc(100% - 1.5rem);" accept=".doc,.docx,.docm,.odt,.pdf,.xls,.xlsx,.zip,.jpg,.jpeg,.gif,.png">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['flugbereich'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(flugbereich)%%>', '<input type="checkbox" name="flugbereich_remove" id="flugbereich_remove" value="1"> <label for="flugbereich_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(flugbereich)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(bild1)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="bild1" id="bild1" data-filetypes="jpg|jpeg|gif|png|webp" data-maxsize="4096000" style="max-width: calc(100% - 1.5rem);" accept="capture=camera,image/*">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['bild1'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(bild1)%%>', '<input type="checkbox" name="bild1_remove" id="bild1_remove" value="1"> <label for="bild1_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(bild1)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(bild2)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="bild2" id="bild2" data-filetypes="jpg|jpeg|gif|png|webp" data-maxsize="4096000" style="max-width: calc(100% - 1.5rem);" accept="capture=camera,image/*">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['bild2'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(bild2)%%>', '<input type="checkbox" name="bild2_remove" id="bild2_remove" value="1"> <label for="bild2_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(bild2)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(bild3)%%>', ($noUploads ? '' : "<div>{$Translation['upload image']}</div>" . '<input type="file" name="bild3" id="bild3" data-filetypes="jpg|jpeg|gif|png|webp" data-maxsize="4096000" style="max-width: calc(100% - 1.5rem);" accept="capture=camera,image/*">' . '<i class="text-danger clear-upload hidden pull-right" style="margin-top: -.1em; font-size: large;">&times;</i>'), $templateCode);
	if($allowUpdate && $row['bild3'] != '') {
		$templateCode = str_replace('<%%REMOVEFILE(bild3)%%>', '<input type="checkbox" name="bild3_remove" id="bild3_remove" value="1"> <label for="bild3_remove" style="color: red; font-weight: bold;">'.$Translation['remove image'].'</label>', $templateCode);
	} else {
		$templateCode = str_replace('<%%REMOVEFILE(bild3)%%>', '', $templateCode);
	}
	$templateCode = str_replace('<%%UPLOADFILE(kontrollzone)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(besonderheit)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(beschreibung)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(erfasser)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(erfasst)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(geaendert_von)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(geaendert)%%>', '', $templateCode);

	// process values
	if($hasSelectedId) {
		if( $dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', safe_html($urow['id']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(id)%%>', html_attr($row['id']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode($urow['id']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(flugplatznummer)%%>', safe_html($urow['flugplatznummer']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(flugplatznummer)%%>', html_attr($row['flugplatznummer']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flugplatznummer)%%>', urlencode($urow['flugplatznummer']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(artikel_16)%%>', safe_html($urow['artikel_16']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(artikel_16)%%>', html_attr($row['artikel_16']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(artikel_16)%%>', urlencode($urow['artikel_16']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(artikel16)%%>', safe_html($urow['artikel16']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(artikel16)%%>', html_attr($row['artikel16']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(artikel16)%%>', urlencode($urow['artikel16']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(mfbo)%%>', safe_html($urow['mfbo']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(mfbo)%%>', html_attr($row['mfbo']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(mfbo)%%>', urlencode($urow['mfbo']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(richtlinie)%%>', safe_html($urow['richtlinie']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(richtlinie)%%>', html_attr($row['richtlinie']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(richtlinie)%%>', urlencode($urow['richtlinie']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(flugplatzordnung)%%>', safe_html($urow['flugplatzordnung']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(flugplatzordnung)%%>', html_attr($row['flugplatzordnung']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flugplatzordnung)%%>', urlencode($urow['flugplatzordnung']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(verhaltensregeln)%%>', safe_html($urow['verhaltensregeln']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(verhaltensregeln)%%>', html_attr($row['verhaltensregeln']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(verhaltensregeln)%%>', urlencode($urow['verhaltensregeln']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(sonstige_datei)%%>', safe_html($urow['sonstige_datei']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(sonstige_datei)%%>', html_attr($row['sonstige_datei']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(sonstige_datei)%%>', urlencode($urow['sonstige_datei']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(vereinsname)%%>', safe_html($urow['vereinsname']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(vereinsname)%%>', html_attr($row['vereinsname']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(vereinsname)%%>', urlencode($urow['vereinsname']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(bundesland)%%>', safe_html($urow['bundesland']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(bundesland)%%>', html_attr($row['bundesland']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(bundesland)%%>', urlencode($urow['bundesland']), $templateCode);
		$templateCode = str_replace('<%%VALUE(webseite)%%>', safe_html($urow['webseite'], $fieldsAreEditable), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(webseite)%%>', urlencode($urow['webseite']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(telefon)%%>', safe_html($urow['telefon']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(telefon)%%>', html_attr($row['telefon']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(telefon)%%>', urlencode($urow['telefon']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(vorname)%%>', safe_html($urow['vorname']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(vorname)%%>', html_attr($row['vorname']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(vorname)%%>', urlencode($urow['vorname']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(nachname)%%>', safe_html($urow['nachname']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(nachname)%%>', html_attr($row['nachname']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(nachname)%%>', urlencode($urow['nachname']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(email)%%>', safe_html($urow['email']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(email)%%>', html_attr($row['email']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(email)%%>', urlencode($urow['email']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(zvr)%%>', safe_html($urow['zvr']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(zvr)%%>', html_attr($row['zvr']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(zvr)%%>', urlencode($urow['zvr']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(flughoehe)%%>', safe_html($urow['flughoehe']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(flughoehe)%%>', html_attr($row['flughoehe']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flughoehe)%%>', urlencode($urow['flughoehe']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(mtom)%%>', safe_html($urow['mtom']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(mtom)%%>', html_attr($row['mtom']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(mtom)%%>', urlencode($urow['mtom']), $templateCode);
		$templateCode = str_replace('<%%VALUE(google_map)%%>', html_attr($row['google_map']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(google_map)%%>', urlencode($urow['google_map']), $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAP(google_map)%%>', get_embed('googlemap', $urow['google_map'], '100', '360', 'html'), $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAPPINPOINT(google_map)%%>', get_embed('googlemap', $urow['google_map'], '100', '360', 'html-pinpoint'), $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAPTHUMB(google_map)%%>', thisOr(get_embed('googlemap', $urow['google_map'], '100', '360', 'thumbnail'), 'blank.gif'), $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAPTHUMBPINPOINT(google_map)%%>', thisOr(get_embed('googlemap', $urow['google_map'], '100', '360', 'thumbnail-pinpoint'), 'blank.gif'), $templateCode);
		$templateCode = str_replace('<%%VALUE(open_street_map)%%>', safe_html($urow['open_street_map'], $fieldsAreEditable), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(open_street_map)%%>', urlencode($urow['open_street_map']), $templateCode);
		$templateCode = str_replace('<%%VALUE(acg_map)%%>', safe_html($urow['acg_map'], $fieldsAreEditable), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(acg_map)%%>', urlencode($urow['acg_map']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(flugbereich)%%>', safe_html($urow['flugbereich']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(flugbereich)%%>', html_attr($row['flugbereich']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flugbereich)%%>', urlencode($urow['flugbereich']), $templateCode);
		$row['bild1'] = ($row['bild1'] != '' ? $row['bild1'] : 'blank.gif');
		if( $dvprint) $templateCode = str_replace('<%%VALUE(bild1)%%>', safe_html($urow['bild1']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(bild1)%%>', html_attr($row['bild1']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(bild1)%%>', urlencode($urow['bild1']), $templateCode);
		$row['bild2'] = ($row['bild2'] != '' ? $row['bild2'] : 'blank.gif');
		if( $dvprint) $templateCode = str_replace('<%%VALUE(bild2)%%>', safe_html($urow['bild2']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(bild2)%%>', html_attr($row['bild2']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(bild2)%%>', urlencode($urow['bild2']), $templateCode);
		$row['bild3'] = ($row['bild3'] != '' ? $row['bild3'] : 'blank.gif');
		if( $dvprint) $templateCode = str_replace('<%%VALUE(bild3)%%>', safe_html($urow['bild3']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(bild3)%%>', html_attr($row['bild3']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(bild3)%%>', urlencode($urow['bild3']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(kontrollzone)%%>', safe_html($urow['kontrollzone']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(kontrollzone)%%>', html_attr($row['kontrollzone']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(kontrollzone)%%>', urlencode($urow['kontrollzone']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(besonderheit)%%>', safe_html($urow['besonderheit']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(besonderheit)%%>', html_attr($row['besonderheit']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(besonderheit)%%>', urlencode($urow['besonderheit']), $templateCode);
		$templateCode = str_replace('<%%VALUE(beschreibung)%%>', safe_html($urow['beschreibung'], $fieldsAreEditable), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(beschreibung)%%>', urlencode($urow['beschreibung']), $templateCode);
		$templateCode = str_replace('<%%VALUE(erfasser)%%>', safe_html($urow['erfasser']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(erfasser)%%>', urlencode($urow['erfasser']), $templateCode);
		$templateCode = str_replace('<%%VALUE(erfasst)%%>', safe_html($urow['erfasst']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(erfasst)%%>', urlencode($urow['erfasst']), $templateCode);
		$templateCode = str_replace('<%%VALUE(geaendert_von)%%>', safe_html($urow['geaendert_von']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(geaendert_von)%%>', urlencode($urow['geaendert_von']), $templateCode);
		$templateCode = str_replace('<%%VALUE(geaendert)%%>', safe_html($urow['geaendert']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(geaendert)%%>', urlencode($urow['geaendert']), $templateCode);
	} else {
		$templateCode = str_replace('<%%VALUE(id)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(flugplatznummer)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flugplatznummer)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(artikel_16)%%>', 'Ja', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(artikel_16)%%>', urlencode('Ja'), $templateCode);
		$templateCode = str_replace('<%%VALUE(artikel16)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(artikel16)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(mfbo)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(mfbo)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(richtlinie)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(richtlinie)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(flugplatzordnung)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flugplatzordnung)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(verhaltensregeln)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(verhaltensregeln)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(sonstige_datei)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(sonstige_datei)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(vereinsname)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(vereinsname)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(bundesland)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(bundesland)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(webseite)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(webseite)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(telefon)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(telefon)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(vorname)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(vorname)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(nachname)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(nachname)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(email)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(email)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(zvr)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(zvr)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(flughoehe)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flughoehe)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(mtom)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(mtom)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(google_map)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(google_map)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAP(google_map)%%>', '', $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAPTHUMB(google_map)%%>', 'blank.gif', $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAPPINPOINT(google_map)%%>', '', $templateCode);
		$templateCode = str_replace('<%%GOOGLEMAPTHUMBPINPOINT(google_map)%%>', 'blank.gif', $templateCode);
		$templateCode = str_replace('<%%VALUE(open_street_map)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(open_street_map)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(acg_map)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(acg_map)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(flugbereich)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(flugbereich)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(bild1)%%>', 'blank.gif', $templateCode);
		$templateCode = str_replace('<%%VALUE(bild2)%%>', 'blank.gif', $templateCode);
		$templateCode = str_replace('<%%VALUE(bild3)%%>', 'blank.gif', $templateCode);
		$templateCode = str_replace('<%%VALUE(kontrollzone)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(kontrollzone)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(besonderheit)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(besonderheit)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(beschreibung)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(beschreibung)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(erfasser)%%>', '<%%creatorUsername%%>', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(erfasser)%%>', urlencode('<%%creatorUsername%%>'), $templateCode);
		$templateCode = str_replace('<%%VALUE(erfasst)%%>', '<%%creationDateTime%%>', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(erfasst)%%>', urlencode('<%%creationDateTime%%>'), $templateCode);
		$templateCode = str_replace('<%%VALUE(geaendert_von)%%>', '<%%editorUsername%%>', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(geaendert_von)%%>', urlencode('<%%editorUsername%%>'), $templateCode);
		$templateCode = str_replace('<%%VALUE(geaendert)%%>', '<%%editingDateTime%%>', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(geaendert)%%>', urlencode('<%%editingDateTime%%>'), $templateCode);
	}

	// process translations
	$templateCode = parseTemplate($templateCode);

	// clear scrap
	$templateCode = str_replace('<%%', '<!-- ', $templateCode);
	$templateCode = str_replace('%%>', ' -->', $templateCode);

	// hide links to inaccessible tables
	if(Request::val('dvprint_x') == '') {
		$templateCode .= "\n\n<script>\$j(function() {\n";
		$arrTables = getTableList();
		foreach($arrTables as $name => $caption) {
			$templateCode .= "\t\$j('#{$name}_link').removeClass('hidden');\n";
			$templateCode .= "\t\$j('#xs_{$name}_link').removeClass('hidden');\n";
		}

		$templateCode .= $jsReadOnly;
		$templateCode .= $jsEditable;

		if(!$hasSelectedId) {
			$templateCode.="\n\tif(document.getElementById('artikel16Edit')) { document.getElementById('artikel16Edit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('artikel16EditLink')) { document.getElementById('artikel16EditLink').style.display='none'; }";
			$templateCode.="\n\tif(document.getElementById('mfboEdit')) { document.getElementById('mfboEdit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('mfboEditLink')) { document.getElementById('mfboEditLink').style.display='none'; }";
			$templateCode.="\n\tif(document.getElementById('richtlinieEdit')) { document.getElementById('richtlinieEdit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('richtlinieEditLink')) { document.getElementById('richtlinieEditLink').style.display='none'; }";
			$templateCode.="\n\tif(document.getElementById('flugplatzordnungEdit')) { document.getElementById('flugplatzordnungEdit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('flugplatzordnungEditLink')) { document.getElementById('flugplatzordnungEditLink').style.display='none'; }";
			$templateCode.="\n\tif(document.getElementById('verhaltensregelnEdit')) { document.getElementById('verhaltensregelnEdit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('verhaltensregelnEditLink')) { document.getElementById('verhaltensregelnEditLink').style.display='none'; }";
			$templateCode.="\n\tif(document.getElementById('sonstige_dateiEdit')) { document.getElementById('sonstige_dateiEdit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('sonstige_dateiEditLink')) { document.getElementById('sonstige_dateiEditLink').style.display='none'; }";
			$templateCode.="\n\tif(document.getElementById('flugbereichEdit')) { document.getElementById('flugbereichEdit').style.display='inline'; }";
			$templateCode.="\n\tif(document.getElementById('flugbereichEditLink')) { document.getElementById('flugbereichEditLink').style.display='none'; }";
		}

		$templateCode.="\n});</script>\n";
	}

	// ajaxed auto-fill fields
	$templateCode .= '<script>';
	$templateCode .= '$j(function() {';


	$templateCode.="});";
	$templateCode.="</script>";
	$templateCode .= $lookups;

	// handle enforced parent values for read-only lookup fields
	$filterField = Request::val('FilterField');
	$filterOperator = Request::val('FilterOperator');
	$filterValue = Request::val('FilterValue');

	// don't include blank images in lightbox gallery
	$templateCode = preg_replace('/blank.gif" data-lightbox=".*?"/', 'blank.gif"', $templateCode);

	// don't display empty email links
	$templateCode=preg_replace('/<a .*?href="mailto:".*?<\/a>/', '', $templateCode);

	/* default field values */
	$rdata = $jdata = get_defaults('flugplaetze_oe');
	if($hasSelectedId) {
		$jdata = get_joined_record('flugplaetze_oe', $selectedId);
		if($jdata === false) $jdata = get_defaults('flugplaetze_oe');
		$rdata = $row;
	}
	$templateCode .= loadView('flugplaetze_oe-ajax-cache', ['rdata' => $rdata, 'jdata' => $jdata]);

	// hook: flugplaetze_oe_dv
	if(function_exists('flugplaetze_oe_dv')) {
		$args = [];
		flugplaetze_oe_dv(($hasSelectedId ? $selectedId : FALSE), getMemberInfo(), $templateCode, $args);
	}

	return $templateCode;
}